/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.util.HashMap;
import java.util.Map;

public final class MediaTypeIds {
    private static final Map<String, Short> idByType = new HashMap<String, Short>(32);
    private static final Map<Short, String> typeById = new HashMap<Short, String>(32);

    public static Short getId(String mediaType) {
        return idByType.get(mediaType);
    }

    public static String getMediaType(Short id) {
        return typeById.get(id);
    }

    static {
        idByType.put("application/x-java-object", (short)1);
        idByType.put("application/json", (short)2);
        idByType.put("application/octet-stream", (short)3);
        idByType.put("application/pdf", (short)4);
        idByType.put("application/rtf", (short)5);
        idByType.put("application/zip", (short)6);
        idByType.put("image/gif", (short)7);
        idByType.put("image/jpeg", (short)8);
        idByType.put("image/png", (short)9);
        idByType.put("text/css", (short)10);
        idByType.put("text/csv", (short)11);
        idByType.put("application/x-protostream", (short)12);
        idByType.put("text/plain", (short)13);
        idByType.put("text/html", (short)14);
        idByType.put("application/x-jboss-marshalling", (short)15);
        idByType.put("application/x-infinispan-marshalling", (short)16);
        idByType.forEach((key, value) -> typeById.put((Short)value, (String)key));
    }
}

