/*
 * Decompiled with CFR 0.152.
 */
package org.fhir.ucum;

import org.fhir.ucum.UcumException;
import org.fhir.ucum.Utilities;

public class Decimal {
    private int precision;
    private boolean scientific;
    private boolean negative;
    private String digits;
    private int decimal;

    private Decimal() {
    }

    public Decimal(String value) throws UcumException {
        value = value.toLowerCase();
        if (value.contains("e")) {
            this.setValueScientific(value);
        } else {
            this.setValueDecimal(value);
        }
    }

    public Decimal(String value, int precision) throws UcumException {
        value = value.toLowerCase();
        if (value.contains("e")) {
            this.setValueScientific(value);
        } else {
            this.setValueDecimal(value);
        }
        this.precision = precision;
    }

    public Decimal(int i) {
        try {
            this.setValueDecimal(Integer.toString(i));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setValueDecimal(String value) throws UcumException {
        this.scientific = false;
        int dec = -1;
        this.negative = value.startsWith("-");
        if (this.negative) {
            value = value.substring(1);
        }
        while (value.startsWith("0") && value.length() > 1) {
            value = value.substring(1);
        }
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '.' && dec == -1) {
                dec = i;
                continue;
            }
            if (Character.isDigit(value.charAt(i))) continue;
            throw new UcumException("'" + value + "' is not a valid decimal");
        }
        if (dec == -1) {
            this.precision = value.length();
            this.decimal = value.length();
            this.digits = value;
        } else {
            if (dec == value.length() - 1) {
                throw new UcumException("'" + value + "' is not a valid decimal");
            }
            this.decimal = dec;
            this.precision = this.allZeros(value, 1) ? value.length() - 1 : this.countSignificants(value);
            this.digits = this.delete(value, this.decimal, 1);
            if (this.allZeros(this.digits, 0)) {
                ++this.precision;
            } else {
                while (this.digits.charAt(0) == '0') {
                    this.digits = this.digits.substring(1);
                    --this.decimal;
                }
            }
        }
    }

    private boolean allZeros(String s, int start) {
        boolean result = true;
        for (int i = start; i < s.length(); ++i) {
            if (s.charAt(i) == '0') continue;
            result = false;
        }
        return result;
    }

    private int countSignificants(String value) {
        int i = value.indexOf(".");
        if (i > -1) {
            value = this.delete(value, i, 1);
        }
        while (value.charAt(0) == '0') {
            value = value.substring(1);
        }
        return value.length();
    }

    private String delete(String value, int offset, int length) {
        if (offset == 0) {
            return value.substring(length);
        }
        return value.substring(0, offset) + value.substring(offset + length);
    }

    private void setValueScientific(String value) throws UcumException {
        int i = value.indexOf("e");
        String s = value.substring(0, i);
        String e = value.substring(i + 1);
        if (Utilities.noString(s) || s.equals("-") || !Utilities.isDecimal(s)) {
            throw new UcumException("'" + value + "' is not a valid decimal (numeric)");
        }
        if (Utilities.noString(e) || e.equals("-") || !Utilities.isInteger(e)) {
            throw new UcumException("'" + value + "' is not a valid decimal (exponent)");
        }
        this.setValueDecimal(s);
        this.scientific = true;
        for (i = e.charAt(0) == '-' ? 1 : 0; i < e.length(); ++i) {
            if (Character.isDigit(e.charAt(i))) continue;
            throw new UcumException("" + value + "' is not a valid decimal");
        }
        i = Integer.parseInt(e);
        this.decimal += i;
    }

    private String stringMultiply(char c, int i) {
        return Utilities.padLeft("", c, i);
    }

    private String insert(String ins, String value, int offset) {
        if (offset == 0) {
            return ins + value;
        }
        return value.substring(0, offset) + ins + value.substring(offset);
    }

    public String toString() {
        return this.asDecimal();
    }

    public Decimal copy() {
        Decimal result = new Decimal();
        result.precision = this.precision;
        result.scientific = this.scientific;
        result.negative = this.negative;
        result.digits = this.digits;
        result.decimal = this.decimal;
        return result;
    }

    public static Decimal zero() {
        try {
            return new Decimal("0");
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isZero() {
        return this.allZeros(this.digits, 0);
    }

    public static Decimal one() {
        try {
            return new Decimal("1");
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isOne() {
        Decimal one = Decimal.one();
        return this.comparesTo(one) == 0;
    }

    public boolean equals(Decimal other) {
        return this.comparesTo(other) == 0;
    }

    public int comparesTo(Decimal other) {
        if (other == null) {
            return 0;
        }
        if (this.negative && !other.negative) {
            return -1;
        }
        if (!this.negative && other.negative) {
            return 1;
        }
        int max = Math.max(this.decimal, other.decimal);
        String s1 = this.stringMultiply('0', max - this.decimal + 1) + this.digits;
        String s2 = this.stringMultiply('0', max - other.decimal + 1) + other.digits;
        if (s1.length() < s2.length()) {
            s1 = s1 + this.stringMultiply('0', s2.length() - s1.length());
        } else if (s2.length() < s1.length()) {
            s2 = s2 + this.stringMultiply('0', s1.length() - s2.length());
        }
        int result = s1.compareTo(s2);
        if (this.negative) {
            result = -result;
        }
        return result;
    }

    public boolean isWholeNumber() {
        return !this.asDecimal().contains(".");
    }

    public String asDecimal() {
        String result = this.digits;
        if (this.decimal != this.digits.length()) {
            result = this.decimal < 0 ? "0." + this.stringMultiply('0', 0 - this.decimal) + this.digits : (this.decimal < result.length() ? (this.decimal == 0 ? "0." + result : this.insert(".", result, this.decimal)) : result + this.stringMultiply('0', this.decimal - result.length()));
        }
        if (this.negative && !this.allZeros(result, 0)) {
            result = "-" + result;
        }
        return result;
    }

    public int asInteger() throws UcumException {
        if (!this.isWholeNumber()) {
            throw new UcumException("Unable to represent " + this.toString() + " as an integer");
        }
        if (this.comparesTo(new Decimal(Integer.MIN_VALUE)) < 0) {
            throw new UcumException("Unable to represent " + this.toString() + " as a signed 8 byte integer");
        }
        if (this.comparesTo(new Decimal(Integer.MAX_VALUE)) > 0) {
            throw new UcumException("Unable to represent " + this.toString() + " as a signed 8 byte integer");
        }
        return Integer.parseInt(this.asDecimal());
    }

    public String asScientific() {
        String result = this.digits;
        boolean zero = this.allZeros(result, 0);
        if (zero) {
            result = this.precision < 2 ? "0e0" : "0." + this.stringMultiply('0', this.precision - 1) + "e0";
        } else {
            if (this.digits.length() > 1) {
                result = this.insert(".", result, 1);
            }
            result = result + 'e' + Integer.toString(this.decimal - 1);
        }
        if (this.negative && !zero) {
            result = '-' + result;
        }
        return result;
    }

    public Decimal trunc() {
        if (this.decimal < 0) {
            return Decimal.zero();
        }
        Decimal result = this.copy();
        if (result.digits.length() >= result.decimal) {
            result.digits = result.digits.substring(0, result.decimal);
        }
        if (Utilities.noString(result.digits)) {
            result.digits = "0";
            result.decimal = 1;
            result.negative = false;
        }
        return result;
    }

    public Decimal add(Decimal other) {
        if (other == null) {
            return null;
        }
        if (this.negative == other.negative) {
            Decimal result = this.doAdd(other);
            result.negative = this.negative;
            return result;
        }
        if (this.negative) {
            return other.doSubtract(this);
        }
        return this.doSubtract(other);
    }

    public Decimal subtract(Decimal other) {
        Decimal result;
        if (other == null) {
            return null;
        }
        if (this.negative && !other.negative) {
            result = this.doAdd(other);
            result.negative = true;
        } else if (!this.negative && other.negative) {
            result = this.doAdd(other);
        } else if (this.negative && other.negative) {
            result = this.doSubtract(other);
            result.negative = !result.negative;
        } else {
            result = other.doSubtract(this);
            result.negative = !result.negative;
        }
        return result;
    }

    private Decimal doAdd(Decimal other) {
        int max = Math.max(this.decimal, other.decimal);
        String s1 = this.stringMultiply('0', max - this.decimal + 1) + this.digits;
        String s2 = this.stringMultiply('0', max - other.decimal + 1) + other.digits;
        if (s1.length() < s2.length()) {
            s1 = s1 + this.stringMultiply('0', s2.length() - s1.length());
        } else if (s2.length() < s1.length()) {
            s2 = s2 + this.stringMultiply('0', s1.length() - s2.length());
        }
        String s3 = this.stringAddition(s1, s2);
        if (s3.charAt(0) == '1') {
            ++max;
        } else {
            s3 = this.delete(s3, 0, 1);
        }
        if (max != s3.length()) {
            if (max < 0) {
                throw new Error("Unhandled");
            }
            if (max < s3.length()) {
                s3 = this.insert(".", s3, max);
            } else {
                throw new Error("Unhandled");
            }
        }
        Decimal result = new Decimal();
        try {
            result.setValueDecimal(s3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = result.scientific = this.scientific || other.scientific;
        result.precision = this.decimal < other.decimal ? this.precision : (other.decimal < this.decimal ? other.precision : Math.min(this.precision, other.precision));
        return result;
    }

    private int dig(char c) {
        return c - 48;
    }

    private char cdig(int i) {
        return (char)(i + 48);
    }

    private Decimal doSubtract(Decimal other) {
        String s3;
        boolean neg;
        int max = Math.max(this.decimal, other.decimal);
        String s1 = this.stringMultiply('0', max - this.decimal + 1) + this.digits;
        String s2 = this.stringMultiply('0', max - other.decimal + 1) + other.digits;
        if (s1.length() < s2.length()) {
            s1 = s1 + this.stringMultiply('0', s2.length() - s1.length());
        } else if (s2.length() < s1.length()) {
            s2 = s2 + this.stringMultiply('0', s1.length() - s2.length());
        }
        boolean bl = neg = s1.compareTo(s2) < 0;
        if (neg) {
            s3 = s2;
            s2 = s1;
            s1 = s3;
        }
        if ((s3 = this.stringSubtraction(s1, s2)).charAt(0) == '1') {
            ++max;
        } else {
            s3 = this.delete(s3, 0, 1);
        }
        if (max != s3.length()) {
            if (max < 0) {
                throw new Error("Unhandled");
            }
            if (max < s3.length()) {
                s3 = this.insert(".", s3, max);
            } else {
                throw new Error("Unhandled");
            }
        }
        Decimal result = new Decimal();
        try {
            result.setValueDecimal(s3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.negative = neg;
        boolean bl2 = result.scientific = this.scientific || other.scientific;
        result.precision = this.decimal < other.decimal ? this.precision : (other.decimal < this.decimal ? other.precision : Math.min(this.precision, other.precision));
        return result;
    }

    private String stringAddition(String s1, String s2) {
        assert (s1.length() == s2.length());
        char[] result = new char[s2.length()];
        for (int i = 0; i < s2.length(); ++i) {
            result[i] = 48;
        }
        int c = 0;
        for (int i = s1.length() - 1; i >= 0; --i) {
            int t = c + this.dig(s1.charAt(i)) + this.dig(s2.charAt(i));
            result[i] = this.cdig(t % 10);
            c = t / 10;
        }
        assert (c == 0);
        return new String(result);
    }

    private String stringSubtraction(String s1, String s2) {
        assert (s1.length() == s2.length());
        char[] result = new char[s2.length()];
        for (int i = 0; i < s2.length(); ++i) {
            result[i] = 48;
        }
        int c = 0;
        for (int i = s1.length() - 1; i >= 0; --i) {
            int t = c + (this.dig(s1.charAt(i)) - this.dig(s2.charAt(i)));
            if (t < 0) {
                t += 10;
                if (i == 0) {
                    throw new Error("internal logic error");
                }
                s1 = this.replaceChar(s1, i - 1, this.cdig(this.dig(s1.charAt(i - 1)) - 1));
            }
            result[i] = this.cdig(t);
        }
        assert (c == 0);
        return new String(result);
    }

    private String replaceChar(String s, int offset, char c) {
        if (offset == 0) {
            return String.valueOf(c) + s.substring(1);
        }
        return s.substring(0, offset) + c + s.substring(offset + 1);
    }

    public Decimal multiply(Decimal other) {
        int c;
        if (other == null) {
            return null;
        }
        if (this.isZero() || other.isZero()) {
            return Decimal.zero();
        }
        int max = Math.max(this.decimal, other.decimal);
        String s1 = this.stringMultiply('0', max - this.decimal + 1) + this.digits;
        String s2 = this.stringMultiply('0', max - other.decimal + 1) + other.digits;
        if (s1.length() < s2.length()) {
            s1 = s1 + this.stringMultiply('0', s2.length() - s1.length());
        } else if (s2.length() < s1.length()) {
            s2 = s2 + this.stringMultiply('0', s1.length() - s2.length());
        }
        if (s2.compareTo(s1) > 0) {
            String s3 = s1;
            s1 = s2;
            s2 = s3;
        }
        String[] s = new String[s2.length()];
        int t = 0;
        for (int i = s2.length() - 1; i >= 0; --i) {
            s[i] = this.stringMultiply('0', s2.length() - (i + 1));
            c = 0;
            for (int j = s1.length() - 1; j >= 0; --j) {
                t = c + this.dig(s1.charAt(j)) * this.dig(s2.charAt(i));
                s[i] = this.insert(String.valueOf(this.cdig(t % 10)), s[i], 0);
                c = t / 10;
            }
            while (c > 0) {
                s[i] = this.insert(String.valueOf(this.cdig(t % 10)), s[i], 0);
                c = t / 10;
            }
        }
        t = 0;
        for (String sv : s) {
            t = Math.max(t, sv.length());
        }
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.stringMultiply('0', t - s[i].length()) + s[i];
        }
        String res = "";
        c = 0;
        for (int i = t - 1; i >= 0; --i) {
            for (int j = 0; j < s.length; ++j) {
                c += this.dig(s[j].charAt(i));
            }
            res = this.insert(String.valueOf(this.cdig(c % 10)), res, 0);
            c /= 10;
        }
        if (c > 0) {
            throw new Error("internal logic error");
        }
        int dec = res.length() - (s1.length() - (max + 1)) * 2;
        while (!Utilities.noString(res) && !res.equals("0") && res.startsWith("0")) {
            res = res.substring(1);
            --dec;
        }
        int prec = 0;
        prec = this.isWholeNumber() && other.isWholeNumber() ? Math.max(Math.max(this.digits.length(), other.digits.length()), Math.min(this.precision, other.precision)) : (this.isWholeNumber() ? other.precision : (other.isWholeNumber() ? this.precision : Math.min(this.precision, other.precision)));
        while (res.length() > prec && res.charAt(res.length() - 1) == '0') {
            res = this.delete(res, res.length() - 1, 1);
        }
        Decimal result = new Decimal();
        try {
            result.setValueDecimal(res);
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.precision = prec;
        result.decimal = dec;
        result.negative = this.negative != other.negative;
        result.scientific = this.scientific || other.scientific;
        return result;
    }

    public Decimal divide(Decimal other) throws UcumException {
        int prec;
        int vi;
        String w;
        if (other == null) {
            return null;
        }
        if (this.isZero()) {
            return Decimal.zero();
        }
        if (other.isZero()) {
            throw new UcumException("Attempt to divide " + this.toString() + " by zero");
        }
        String s = "0" + other.digits;
        int m = Math.max(this.digits.length(), other.digits.length()) + 40;
        String[] tens = new String[10];
        tens[0] = this.stringAddition(this.stringMultiply('0', s.length()), s);
        for (int i = 1; i < 10; ++i) {
            tens[i] = this.stringAddition(tens[i - 1], s);
        }
        String v = this.digits;
        String r = "";
        int l = 0;
        int d = this.digits.length() - this.decimal + 1 - (other.digits.length() - other.decimal + 1);
        while (v.length() < tens[0].length()) {
            v = v + "0";
            ++d;
        }
        if (v.substring(0, other.digits.length()).compareTo(other.digits) < 0) {
            if (v.length() == tens[0].length()) {
                v = v + '0';
                ++d;
            }
            w = v.substring(0, other.digits.length() + 1);
            vi = w.length();
        } else {
            w = "0" + v.substring(0, other.digits.length());
            vi = w.length() - 1;
        }
        boolean handled = false;
        while (!handled || l <= m && (vi < v.length() || !Utilities.noString(w) && !this.allZeros(w, 0))) {
            ++l;
            handled = true;
            boolean proc = false;
            for (int i = 8; i >= 0; --i) {
                if (tens[i].compareTo(w) > 0) continue;
                proc = true;
                r = r + this.cdig(i + 1);
                w = this.trimLeadingZeros(this.stringSubtraction(w, tens[i]));
                if (handled && (l > m || vi >= v.length() && (Utilities.noString(w) || this.allZeros(w, 0)))) break;
                if (vi < v.length()) {
                    w = w + v.charAt(vi);
                    ++vi;
                    handled = false;
                } else {
                    w = w + '0';
                    ++d;
                }
                while (w.length() < tens[0].length()) {
                    w = '0' + w;
                }
                break;
            }
            if (proc) continue;
            assert (w.charAt(0) == '0');
            w = this.delete(w, 0, 1);
            r = r + "0";
            if (handled && (l > m || vi >= v.length() && (Utilities.noString(w) || this.allZeros(w, 0)))) continue;
            if (vi < v.length()) {
                w = w + v.charAt(vi);
                ++vi;
                handled = false;
            } else {
                w = w + '0';
                ++d;
            }
            while (w.length() < tens[0].length()) {
                w = '0' + w;
            }
        }
        if (this.isWholeNumber() && other.isWholeNumber() && l < m) {
            for (int i = 0; i < d; ++i) {
                if (r.charAt(r.length() - 1) != '0') continue;
                r = this.delete(r, r.length() - 1, 1);
                --d;
            }
            prec = 100;
        } else {
            prec = this.isWholeNumber() && other.isWholeNumber() ? Math.max(this.digits.length(), other.digits.length()) : (this.isWholeNumber() ? Math.max(other.precision, r.length() - d) : (other.isWholeNumber() ? Math.max(this.precision, r.length() - d) : Math.max(Math.min(this.precision, other.precision), r.length() - d)));
            if (r.length() > prec) {
                boolean up;
                d -= r.length() - prec;
                char dig = r.charAt(prec);
                boolean bl = up = dig >= '5';
                if (up) {
                    char[] rs = r.substring(0, prec).toCharArray();
                    boolean carry = true;
                    for (int i = rs.length - 1; carry && i >= 0; --i) {
                        char ls = rs[i];
                        if (ls == '9') {
                            rs[i] = 48;
                            continue;
                        }
                        rs[i] = ls = (char)(ls + '\u0001');
                        carry = false;
                    }
                    if (carry) {
                        r = "1" + new String(rs);
                        ++d;
                    } else {
                        r = new String(rs);
                    }
                } else {
                    r = r.substring(0, prec);
                }
            }
        }
        Decimal result = new Decimal();
        result.setValueDecimal(r);
        result.decimal = r.length() - d;
        result.negative = this.negative != other.negative;
        result.precision = prec;
        result.scientific = this.scientific || other.scientific;
        return result;
    }

    private String trimLeadingZeros(String s) {
        int i;
        if (s == null) {
            return null;
        }
        for (i = 0; i < s.length() && s.charAt(i) == '0'; ++i) {
        }
        if (i == s.length()) {
            return "0";
        }
        return s.substring(i);
    }

    public Decimal divInt(Decimal other) throws UcumException {
        if (other == null) {
            return null;
        }
        Decimal t = this.divide(other);
        return t.trunc();
    }

    public Decimal modulo(Decimal other) throws UcumException {
        if (other == null) {
            return null;
        }
        Decimal t = this.divInt(other);
        Decimal t2 = t.multiply(other);
        return this.subtract(t2);
    }

    public boolean equals(Decimal value, Decimal maxDifference) {
        Decimal diff = this.subtract(value).absolute();
        return diff.comparesTo(maxDifference) <= 0;
    }

    private Decimal absolute() {
        Decimal d = this.copy();
        d.negative = false;
        return d;
    }

    public boolean equals(Object other) {
        if (other instanceof Decimal) {
            return this.asDecimal().equals(((Decimal)other).asDecimal());
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.asDecimal().hashCode();
    }

    public void limitPrecisionTo(Decimal other) {
        if (this.precision > other.precision) {
            this.precision = other.precision;
        }
    }

    public void checkForCouldBeWholeNumber() {
        if (this.precision > 17 && this.digits.length() > 3) {
            int i = this.digits.length() - 2;
            char ch = this.digits.charAt(i);
            if (ch == '9') {
                while (i > 0 && this.digits.charAt(i - 1) == '9') {
                    --i;
                }
                if (i > 0 && i < this.digits.length() - 3) {
                    this.digits = this.digits.substring(0, i - 1) + Character.toString((char)(this.digits.charAt(i - 1) + '\u0001'));
                    this.precision = this.digits.length();
                }
            } else if (ch == '0') {
                while (i > 0 && this.digits.charAt(i - 1) == '0') {
                    --i;
                }
                if (i > 0 && i < this.digits.length() - 3) {
                    this.digits = this.digits.substring(0, i);
                    this.precision = this.digits.length();
                }
            }
        }
    }
}

