/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionBase;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsSession;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLSession
extends ProvSSLSessionBase {
    protected final TlsSession tlsSession;
    protected final SessionParameters sessionParameters;
    protected final JsseSessionParameters jsseSessionParameters;
    protected final AtomicLong lastAccessedTime;

    ProvSSLSession(ProvSSLSessionContext sslSessionContext, ConcurrentHashMap<String, Object> valueMap, String peerHost, int peerPort, long creationTime, TlsSession tlsSession, JsseSessionParameters jsseSessionParameters) {
        super(sslSessionContext, valueMap, peerHost, peerPort, creationTime);
        this.tlsSession = tlsSession;
        this.sessionParameters = tlsSession == null ? null : tlsSession.exportSessionParameters();
        this.jsseSessionParameters = jsseSessionParameters;
        this.lastAccessedTime = new AtomicLong(creationTime);
    }

    long access() {
        long previous;
        long accessTime = ProvSSLSession.getCurrentTime();
        while (accessTime > (previous = this.lastAccessedTime.get()) && !this.lastAccessedTime.compareAndSet(previous, accessTime)) {
        }
        return accessTime;
    }

    @Override
    protected int getCipherSuiteTLS() {
        return null == this.sessionParameters ? 0 : this.sessionParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return null == this.tlsSession ? null : this.tlsSession.getSessionID();
    }

    @Override
    protected JsseSecurityParameters getJsseSecurityParameters() {
        return null;
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return this.jsseSessionParameters;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime.get();
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return null == this.sessionParameters ? null : this.sessionParameters.getLocalCertificate();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        return null;
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return null == this.sessionParameters ? null : this.sessionParameters.getPeerCertificate();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        return null;
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return null == this.sessionParameters ? null : this.sessionParameters.getNegotiatedVersion();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        throw new UnsupportedOperationException();
    }

    TlsSession getTlsSession() {
        return this.tlsSession;
    }

    @Override
    protected void invalidateTLS() {
        if (null != this.tlsSession) {
            this.tlsSession.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && null != this.tlsSession && this.tlsSession.isResumable();
    }

    static final ProvSSLSession createDummySession() {
        return new ProvSSLSession(null, ProvSSLSession.createValueMap(), null, -1, ProvSSLSession.getCurrentTime(), null, new JsseSessionParameters(null, null));
    }
}

