/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class JcaAlgorithmDecomposer
implements AlgorithmDecomposer {
    private static final Map<String, String> SHA_DIGEST_MAP = JcaAlgorithmDecomposer.createSHADigestMap();
    private static final Pattern PATTERN = Pattern.compile("with|and|(?<!padd)in", 2);
    static final JcaAlgorithmDecomposer INSTANCE_JCA = new JcaAlgorithmDecomposer();

    JcaAlgorithmDecomposer() {
    }

    @Override
    public Set<String> decompose(String algorithm) {
        HashSet<String> result = new HashSet<String>();
        if (JsseUtils.isNameSpecified(algorithm)) {
            JcaAlgorithmDecomposer.implDecompose(result, algorithm);
            if (algorithm.contains("SHA")) {
                for (Map.Entry<String, String> entry : SHA_DIGEST_MAP.entrySet()) {
                    JcaAlgorithmDecomposer.includeBothIfEither(result, entry.getKey(), entry.getValue());
                }
            }
        }
        return result;
    }

    static String decomposeDigestName(String algorithm) {
        String result = SHA_DIGEST_MAP.get(algorithm);
        if (result == null) {
            result = algorithm;
        }
        return result;
    }

    static Set<String> decomposeName(String algorithm) {
        HashSet<String> result = new HashSet<String>();
        if (JsseUtils.isNameSpecified(algorithm)) {
            JcaAlgorithmDecomposer.implDecompose(result, algorithm);
            if (algorithm.contains("SHA")) {
                for (Map.Entry<String, String> entry : SHA_DIGEST_MAP.entrySet()) {
                    JcaAlgorithmDecomposer.replaceFirstWithSecond(result, entry.getKey(), entry.getValue());
                }
            }
        }
        return result;
    }

    private static Map<String, String> createSHADigestMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("SHA-1", "SHA1");
        result.put("SHA-224", "SHA224");
        result.put("SHA-256", "SHA256");
        result.put("SHA-384", "SHA384");
        result.put("SHA-512", "SHA512");
        result.put("SHA-512/224", "SHA512/224");
        result.put("SHA-512/256", "SHA512/256");
        return result;
    }

    private static void implDecompose(Set<String> result, String algorithm) {
        for (String section : algorithm.split("/")) {
            if (section.length() <= 0) continue;
            for (String part : PATTERN.split(section)) {
                if (part.length() <= 0) continue;
                result.add(part);
            }
        }
    }

    private static void includeBothIfEither(Set<String> elements, String a, String b) {
        if (elements.contains(a)) {
            elements.add(b);
        } else if (elements.contains(b)) {
            elements.add(a);
        }
    }

    private static void replaceFirstWithSecond(Set<String> elements, String a, String b) {
        if (elements.remove(a)) {
            elements.add(b);
        }
    }
}

