/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class AbstractAlgorithmConstraints
implements BCAlgorithmConstraints {
    protected final AlgorithmDecomposer decomposer;

    AbstractAlgorithmConstraints(AlgorithmDecomposer decomposer) {
        if (decomposer == null) {
            throw new NullPointerException("'decomposer' cannot be null");
        }
        this.decomposer = decomposer;
    }

    protected boolean containsAnyPartIgnoreCase(Set<String> elements, String algorithm) {
        if (elements.isEmpty()) {
            return false;
        }
        if (AbstractAlgorithmConstraints.containsIgnoreCase(elements, algorithm)) {
            return true;
        }
        for (String part : this.decomposer.decompose(algorithm)) {
            if (!AbstractAlgorithmConstraints.containsIgnoreCase(elements, part)) continue;
            return true;
        }
        return false;
    }

    static void checkAlgorithmName(String algorithm) {
        if (!JsseUtils.isNameSpecified(algorithm)) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
    }

    static void checkKey(Key key) {
        if (null == key) {
            throw new NullPointerException("'key' cannot be null");
        }
    }

    static void checkPrimitives(Set<BCCryptoPrimitive> primitives) {
        if (!AbstractAlgorithmConstraints.isPrimitivesSpecified(primitives)) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
    }

    static boolean containsIgnoreCase(Set<String> elements, String s) {
        for (String element : elements) {
            if (!element.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    static boolean isPrimitivesSpecified(Set<BCCryptoPrimitive> primitives) {
        return null != primitives && !primitives.isEmpty();
    }

    static Set<String> asUnmodifiableSet(String[] algorithms) {
        Set<String> result;
        if (null != algorithms && algorithms.length > 0 && !(result = AbstractAlgorithmConstraints.asSet(algorithms)).isEmpty()) {
            return Collections.unmodifiableSet(result);
        }
        return Collections.emptySet();
    }

    static Set<String> asSet(String[] algorithms) {
        HashSet<String> result = new HashSet<String>();
        if (null != algorithms) {
            for (String algorithm : algorithms) {
                if (null == algorithm) continue;
                result.add(algorithm);
            }
        }
        return result;
    }
}

