/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSocketDirect;
import org.bouncycastle.jsse.provider.ProvSSLSocketDirect_9;
import org.bouncycastle.jsse.provider.ProvSSLSocketWrap;
import org.bouncycastle.jsse.provider.ProvSSLSocketWrap_9;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLSocketUtil {
    private static AtomicInteger threadNumber = new AtomicInteger();

    SSLSocketUtil() {
    }

    static ProvSSLSocketDirect create(ContextData contextData, boolean enableSessionCreation, boolean useClientMode, ProvSSLParameters sslParameters) {
        return new ProvSSLSocketDirect_9(contextData, enableSessionCreation, useClientMode, sslParameters);
    }

    static ProvSSLSocketDirect create(ContextData contextData) {
        return new ProvSSLSocketDirect_9(contextData);
    }

    static ProvSSLSocketDirect create(ContextData contextData, InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return new ProvSSLSocketDirect_9(contextData, address, port, clientAddress, clientPort);
    }

    static ProvSSLSocketDirect create(ContextData contextData, InetAddress address, int port) throws IOException {
        return new ProvSSLSocketDirect_9(contextData, address, port);
    }

    static ProvSSLSocketDirect create(ContextData contextData, String host, int port, InetAddress clientAddress, int clientPort) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect_9(contextData, host, port, clientAddress, clientPort);
    }

    static ProvSSLSocketDirect create(ContextData contextData, String host, int port) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect_9(contextData, host, port);
    }

    static ProvSSLSocketWrap create(ContextData contextData, Socket s, InputStream consumed, boolean autoClose) throws IOException {
        return new ProvSSLSocketWrap_9(contextData, s, consumed, autoClose);
    }

    static ProvSSLSocketWrap create(ContextData contextData, Socket s, String host, int port, boolean autoClose) throws IOException {
        return new ProvSSLSocketWrap_9(contextData, s, host, port, autoClose);
    }

    static void handshakeCompleted(Runnable notifyRunnable) {
        String name = "BCJSSE-HandshakeCompleted-" + Integer.toUnsignedString(threadNumber.getAndIncrement());
        new Thread(null, notifyRunnable, name, 0L, false).start();
    }

    static BCExtendedSSLSession importHandshakeSession(SSLSocket sslSocket) {
        SSLSession sslSession;
        if (sslSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sslSocket)).getBCHandshakeSession();
        }
        if (null != sslSocket && null != (sslSession = sslSocket.getHandshakeSession())) {
            return SSLSessionUtil.importSSLSession(sslSession);
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLSocket sslSocket) {
        if (sslSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sslSocket)).getParameters();
        }
        if (null == sslSocket) {
            return null;
        }
        SSLParameters sslParameters = sslSocket.getSSLParameters();
        if (null == sslParameters) {
            throw new RuntimeException("SSLSocket.getSSLParameters returned null");
        }
        return SSLParametersUtil.importSSLParameters(sslParameters);
    }
}

