/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class ECDSAPublicKeyEntryDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final int MAX_ALLOWED_POINT_SIZE = Short.MAX_VALUE;
    public static final int MAX_CURVE_NAME_LENGTH = 1024;
    public static final ECDSAPublicKeyEntryDecoder INSTANCE = new ECDSAPublicKeyEntryDecoder();
    public static final byte ECPOINT_UNCOMPRESSED_FORM_INDICATOR = 4;
    public static final byte ECPOINT_COMPRESSED_VARIANT_2 = 2;
    public static final byte ECPOINT_COMPRESSED_VARIANT_3 = 2;

    public ECDSAPublicKeyEntryDecoder() {
        super(ECCurves.KEY_TYPES);
    }

    @Override
    public PublicKey decodePublicKey(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        ECCurves curve = ECCurves.fromKeyType(keyType);
        if (curve == null) {
            throw new InvalidKeySpecException("Not an EC curve name: " + keyType);
        }
        return this.decodePublicKey(curve, keyData);
    }

    PublicKey decodePublicKey(ECCurves curve, InputStream keyData) throws IOException, GeneralSecurityException {
        ECPoint w;
        String encCurveName;
        String keyCurveName = curve.getName();
        if (!keyCurveName.equals(encCurveName = KeyEntryResolver.decodeString(keyData, 1024))) {
            throw new InvalidKeySpecException("Mismatched key curve name (" + keyCurveName + ") vs. encoded one (" + encCurveName + ")");
        }
        byte[] octets = KeyEntryResolver.readRLEBytes(keyData, Short.MAX_VALUE);
        try {
            w = ECCurves.octetStringToEcPoint(octets);
            if (w == null) {
                throw new InvalidKeySpecException("No ECPoint generated for curve=" + keyCurveName + " from octets=" + BufferUtils.toHex(':', octets));
            }
        }
        catch (RuntimeException e) {
            throw new InvalidKeySpecException("Failed (" + e.getClass().getSimpleName() + ") to generate ECPoint for curve=" + keyCurveName + " from octets=" + BufferUtils.toHex(':', octets) + ": " + e.getMessage());
        }
        ECParameterSpec paramSpec = curve.getParameters();
        return this.generatePublicKey(new ECPublicKeySpec(w, paramSpec));
    }

    @Override
    public String encodePublicKey(OutputStream s, PublicKey k) throws IOException {
        ECPublicKey key = ValidateUtils.checkInstanceOf(k, ECPublicKey.class, "Key must be an ECPublicKey");
        ECParameterSpec params = Objects.requireNonNull(key.getParams(), "No EC parameters available");
        ECCurves curve = Objects.requireNonNull(ECCurves.fromCurveParameters(params), "Cannot determine curve");
        String keyType = curve.getKeyType();
        ECDSAPublicKeyEntryDecoder.encodePublicKey(s, keyType, curve, key.getW());
        return keyType;
    }

    static void encodePublicKey(OutputStream s, String keyType, ECCurves curve, ECPoint w) throws IOException {
        String curveName = curve.getName();
        KeyEntryResolver.encodeString(s, keyType);
        KeyEntryResolver.encodeString(s, curveName);
        ECCurves.ECPointCompression.UNCOMPRESSED.writeECPoint(s, curveName, w);
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("EC");
    }

    @Override
    public KeyPair generateKeyPair(int keySize) throws GeneralSecurityException {
        ECCurves curve = ECCurves.fromCurveSize(keySize);
        if (curve == null) {
            throw new InvalidKeySpecException("Unknown curve for key size=" + keySize);
        }
        KeyPairGenerator gen = this.getKeyPairGenerator();
        gen.initialize(curve.getParameters());
        return gen.generateKeyPair();
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("EC");
    }
}

