/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.maven.plugins.invoker.model.BuildJob;

class JobExecutor {
    private final List<BuildJob> jobs;
    private final int threadsCount;

    JobExecutor(List<BuildJob> jobs, int threadsCount) {
        this.jobs = jobs;
        this.threadsCount = threadsCount;
    }

    public void forEach(ThrowableJobConsumer jobConsumer) {
        Map groupedJobs = this.jobs.stream().sorted(Comparator.comparing(BuildJob::getOrdinal).reversed()).collect(Collectors.groupingBy(BuildJob::getOrdinal, LinkedHashMap::new, Collectors.toList()));
        ExecutorService executorService = Executors.newFixedThreadPool(this.threadsCount);
        groupedJobs.forEach((? super K key, ? super V value) -> {
            List callableJobs = value.stream().map(buildJob -> () -> {
                try {
                    jobConsumer.accept((BuildJob)buildJob);
                }
                catch (Throwable e) {
                    buildJob.setResult("error");
                    buildJob.setFailureMessage(String.valueOf(e));
                }
                return null;
            }).collect(Collectors.toList());
            try {
                executorService.invokeAll(callableJobs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        });
        executorService.shutdownNow();
    }

    static interface ThrowableJobConsumer {
        public void accept(BuildJob var1) throws Throwable;
    }
}

