/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.AbstractDependencyMojo;
import org.apache.maven.plugins.dependency.resolvers.PluginsIncludeExcludeFilter;
import org.apache.maven.plugins.dependency.resolvers.PluginsReactorExcludeFilter;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.ResolverUtil;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="resolve-plugins", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ResolvePluginsMojo
extends AbstractDependencyMojo {
    @Parameter(property="outputFile")
    protected File outputFile;
    @Parameter(property="excludeTransitive", defaultValue="false")
    protected boolean excludeTransitive;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    protected List<String> excludeArtifactIds;
    @Parameter(property="includeArtifactIds", defaultValue="")
    protected List<String> includeArtifactIds;
    @Parameter(property="excludeGroupIds", defaultValue="")
    protected List<String> excludeGroupIds;
    @Parameter(property="includeGroupIds", defaultValue="")
    protected List<String> includeGroupIds;
    @Parameter(property="appendOutput", defaultValue="false")
    protected boolean appendOutput;
    @Parameter(property="excludeReactor", defaultValue="true")
    protected boolean excludeReactor;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter(property="outputAbsoluteArtifactFilename", defaultValue="false")
    private boolean outputAbsoluteArtifactFilename;
    private final ResolverUtil resolverUtil;

    @Inject
    public ResolvePluginsMojo(MavenSession session, BuildContext buildContext, MavenProject project, ResolverUtil resolverUtil) {
        super(session, buildContext, project);
        this.resolverUtil = resolverUtil;
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            Set<Plugin> plugins = this.getProjectPlugins();
            StringBuilder sb = new StringBuilder();
            sb.append(System.lineSeparator());
            sb.append("The following plugins have been resolved:");
            sb.append(System.lineSeparator());
            if (plugins.isEmpty()) {
                sb.append("   none");
                sb.append(System.lineSeparator());
            } else {
                for (Plugin plugin : plugins) {
                    Artifact pluginArtifact = this.resolverUtil.resolvePlugin(plugin);
                    String artifactFilename = null;
                    if (this.outputAbsoluteArtifactFilename) {
                        artifactFilename = Optional.ofNullable(pluginArtifact.getFile()).map(File::getAbsoluteFile).map(File::getPath).orElse(null);
                    }
                    String id = pluginArtifact.toString();
                    sb.append("   ").append(id).append(this.outputAbsoluteArtifactFilename ? ":" + artifactFilename : "").append(System.lineSeparator());
                    if (this.excludeTransitive) continue;
                    for (Artifact artifact : this.resolverUtil.resolveDependencies(plugin)) {
                        artifactFilename = null;
                        if (this.outputAbsoluteArtifactFilename) {
                            artifactFilename = Optional.ofNullable(artifact.getFile()).map(File::getAbsoluteFile).map(File::getPath).orElse(null);
                        }
                        id = artifact.toString();
                        sb.append("      ").append(id).append(this.outputAbsoluteArtifactFilename ? ":" + artifactFilename : "").append(System.lineSeparator());
                    }
                }
                sb.append(System.lineSeparator());
                String output = sb.toString();
                if (this.outputFile == null) {
                    DependencyUtil.log(output, this.getLog());
                } else {
                    String encoding = Objects.toString(this.outputEncoding, "UTF-8");
                    DependencyUtil.write(output, this.outputFile, this.appendOutput, encoding);
                }
            }
        }
        catch (IOException | ArtifactResolutionException | DependencyResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private Set<Plugin> getProjectPlugins() {
        PluginsIncludeExcludeFilter pluginsFilter = new PluginsIncludeExcludeFilter(this.includeGroupIds, this.excludeGroupIds, this.includeArtifactIds, this.excludeArtifactIds);
        PluginsReactorExcludeFilter reactorExclusionFilter = plugin -> true;
        if (this.excludeReactor) {
            reactorExclusionFilter = new PluginsReactorExcludeFilter(this.session.getProjects());
        }
        return this.resolverUtil.getProjectPlugins(this.getProject()).stream().filter(reactorExclusionFilter).filter(pluginsFilter).collect(Collectors.toSet());
    }
}

