/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Resource;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Build
extends BuildBase
implements Serializable,
InputLocationTracker {
    final String sourceDirectory;
    final String scriptSourceDirectory;
    final String testSourceDirectory;
    final String outputDirectory;
    final String testOutputDirectory;
    final List<Extension> extensions;
    final InputLocation sourceDirectoryLocation;
    final InputLocation scriptSourceDirectoryLocation;
    final InputLocation testSourceDirectoryLocation;
    final InputLocation outputDirectoryLocation;
    final InputLocation testOutputDirectoryLocation;
    final InputLocation extensionsLocation;

    Build(Collection<Plugin> plugins, PluginManagement pluginManagement, String defaultGoal, Collection<Resource> resources, Collection<Resource> testResources, String directory, String finalName, Collection<String> filters, String sourceDirectory, String scriptSourceDirectory, String testSourceDirectory, String outputDirectory, String testOutputDirectory, Collection<Extension> extensions, Map<Object, InputLocation> locations, InputLocation location, InputLocation pluginsLocation, InputLocation pluginManagementLocation, InputLocation defaultGoalLocation, InputLocation resourcesLocation, InputLocation testResourcesLocation, InputLocation directoryLocation, InputLocation finalNameLocation, InputLocation filtersLocation, InputLocation sourceDirectoryLocation, InputLocation scriptSourceDirectoryLocation, InputLocation testSourceDirectoryLocation, InputLocation outputDirectoryLocation, InputLocation testOutputDirectoryLocation, InputLocation extensionsLocation) {
        super(plugins, pluginManagement, defaultGoal, resources, testResources, directory, finalName, filters, locations, location, pluginsLocation, pluginManagementLocation, defaultGoalLocation, resourcesLocation, testResourcesLocation, directoryLocation, finalNameLocation, filtersLocation);
        this.sourceDirectory = sourceDirectory;
        this.scriptSourceDirectory = scriptSourceDirectory;
        this.testSourceDirectory = testSourceDirectory;
        this.outputDirectory = outputDirectory;
        this.testOutputDirectory = testOutputDirectory;
        this.extensions = ImmutableCollections.copy(extensions);
        this.sourceDirectoryLocation = sourceDirectoryLocation;
        this.scriptSourceDirectoryLocation = scriptSourceDirectoryLocation;
        this.testSourceDirectoryLocation = testSourceDirectoryLocation;
        this.outputDirectoryLocation = outputDirectoryLocation;
        this.testOutputDirectoryLocation = testOutputDirectoryLocation;
        this.extensionsLocation = extensionsLocation;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getScriptSourceDirectory() {
        return this.scriptSourceDirectory;
    }

    public String getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getTestOutputDirectory() {
        return this.testOutputDirectory;
    }

    @Nonnull
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "sourceDirectory": {
                    return this.sourceDirectoryLocation;
                }
                case "scriptSourceDirectory": {
                    return this.scriptSourceDirectoryLocation;
                }
                case "testSourceDirectory": {
                    return this.testSourceDirectoryLocation;
                }
                case "outputDirectory": {
                    return this.outputDirectoryLocation;
                }
                case "testOutputDirectory": {
                    return this.testOutputDirectoryLocation;
                }
                case "extensions": {
                    return this.extensionsLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return Build.newBuilder(this);
    }

    @Override
    @Nonnull
    public Build withPlugins(Collection<Plugin> plugins) {
        return ((Builder)this.with().plugins((Collection)plugins)).build();
    }

    @Override
    @Nonnull
    public Build withPluginManagement(PluginManagement pluginManagement) {
        return this.with().pluginManagement(pluginManagement).build();
    }

    @Override
    @Nonnull
    public Build withDefaultGoal(String defaultGoal) {
        return this.with().defaultGoal(defaultGoal).build();
    }

    @Override
    @Nonnull
    public Build withResources(Collection<Resource> resources) {
        return ((Builder)this.with().resources((Collection)resources)).build();
    }

    @Override
    @Nonnull
    public Build withTestResources(Collection<Resource> testResources) {
        return ((Builder)this.with().testResources((Collection)testResources)).build();
    }

    @Override
    @Nonnull
    public Build withDirectory(String directory) {
        return this.with().directory(directory).build();
    }

    @Override
    @Nonnull
    public Build withFinalName(String finalName) {
        return this.with().finalName(finalName).build();
    }

    @Override
    @Nonnull
    public Build withFilters(Collection<String> filters) {
        return ((Builder)this.with().filters((Collection)filters)).build();
    }

    @Nonnull
    public Build withSourceDirectory(String sourceDirectory) {
        return this.with().sourceDirectory(sourceDirectory).build();
    }

    @Nonnull
    public Build withScriptSourceDirectory(String scriptSourceDirectory) {
        return this.with().scriptSourceDirectory(scriptSourceDirectory).build();
    }

    @Nonnull
    public Build withTestSourceDirectory(String testSourceDirectory) {
        return this.with().testSourceDirectory(testSourceDirectory).build();
    }

    @Nonnull
    public Build withOutputDirectory(String outputDirectory) {
        return this.with().outputDirectory(outputDirectory).build();
    }

    @Nonnull
    public Build withTestOutputDirectory(String testOutputDirectory) {
        return this.with().testOutputDirectory(testOutputDirectory).build();
    }

    @Nonnull
    public Build withExtensions(Collection<Extension> extensions) {
        return this.with().extensions(extensions).build();
    }

    @Nonnull
    public static Build newInstance() {
        return Build.newInstance(true);
    }

    @Nonnull
    public static Build newInstance(boolean withDefaults) {
        return Build.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Build.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Build from) {
        return Build.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Build from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "Build {" + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends BuildBase.Builder {
        Build base;
        String sourceDirectory;
        String scriptSourceDirectory;
        String testSourceDirectory;
        String outputDirectory;
        String testOutputDirectory;
        Collection<Extension> extensions;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Build base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.sourceDirectory = base.sourceDirectory;
                this.scriptSourceDirectory = base.scriptSourceDirectory;
                this.testSourceDirectory = base.testSourceDirectory;
                this.outputDirectory = base.outputDirectory;
                this.testOutputDirectory = base.testOutputDirectory;
                this.extensions = base.extensions;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Override
        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Override
        @Nonnull
        public Builder resources(Collection<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @Override
        @Nonnull
        public Builder testResources(Collection<Resource> testResources) {
            this.testResources = testResources;
            return this;
        }

        @Override
        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Override
        @Nonnull
        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        @Override
        @Nonnull
        public Builder filters(Collection<String> filters) {
            this.filters = filters;
            return this;
        }

        @Nonnull
        public Builder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        @Nonnull
        public Builder scriptSourceDirectory(String scriptSourceDirectory) {
            this.scriptSourceDirectory = scriptSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder testSourceDirectory(String testSourceDirectory) {
            this.testSourceDirectory = testSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder testOutputDirectory(String testOutputDirectory) {
            this.testOutputDirectory = testOutputDirectory;
            return this;
        }

        @Nonnull
        public Builder extensions(Collection<Extension> extensions) {
            this.extensions = extensions;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Build build() {
            if (!(this.base == null || this.plugins != null && this.plugins != this.base.plugins || this.pluginManagement != null && this.pluginManagement != this.base.pluginManagement || this.defaultGoal != null && this.defaultGoal != this.base.defaultGoal || this.resources != null && this.resources != this.base.resources || this.testResources != null && this.testResources != this.base.testResources || this.directory != null && this.directory != this.base.directory || this.finalName != null && this.finalName != this.base.finalName || this.filters != null && this.filters != this.base.filters || this.sourceDirectory != null && this.sourceDirectory != this.base.sourceDirectory || this.scriptSourceDirectory != null && this.scriptSourceDirectory != this.base.scriptSourceDirectory || this.testSourceDirectory != null && this.testSourceDirectory != this.base.testSourceDirectory || this.outputDirectory != null && this.outputDirectory != this.base.outputDirectory || this.testOutputDirectory != null && this.testOutputDirectory != this.base.testOutputDirectory || this.extensions != null && this.extensions != this.base.extensions)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation pluginsLocation = null;
            InputLocation pluginManagementLocation = null;
            InputLocation defaultGoalLocation = null;
            InputLocation resourcesLocation = null;
            InputLocation testResourcesLocation = null;
            InputLocation directoryLocation = null;
            InputLocation finalNameLocation = null;
            InputLocation filtersLocation = null;
            InputLocation sourceDirectoryLocation = null;
            InputLocation scriptSourceDirectoryLocation = null;
            InputLocation testSourceDirectoryLocation = null;
            InputLocation outputDirectoryLocation = null;
            InputLocation testOutputDirectoryLocation = null;
            InputLocation extensionsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                pluginsLocation = (InputLocation)locations.remove("plugins");
                pluginManagementLocation = (InputLocation)locations.remove("pluginManagement");
                defaultGoalLocation = (InputLocation)locations.remove("defaultGoal");
                resourcesLocation = (InputLocation)locations.remove("resources");
                testResourcesLocation = (InputLocation)locations.remove("testResources");
                directoryLocation = (InputLocation)locations.remove("directory");
                finalNameLocation = (InputLocation)locations.remove("finalName");
                filtersLocation = (InputLocation)locations.remove("filters");
                sourceDirectoryLocation = (InputLocation)locations.remove("sourceDirectory");
                scriptSourceDirectoryLocation = (InputLocation)locations.remove("scriptSourceDirectory");
                testSourceDirectoryLocation = (InputLocation)locations.remove("testSourceDirectory");
                outputDirectoryLocation = (InputLocation)locations.remove("outputDirectory");
                testOutputDirectoryLocation = (InputLocation)locations.remove("testOutputDirectory");
                extensionsLocation = (InputLocation)locations.remove("extensions");
            }
            return new Build(this.plugins != null ? this.plugins : (this.base != null ? this.base.plugins : null), this.pluginManagement != null ? this.pluginManagement : (this.base != null ? this.base.pluginManagement : null), this.defaultGoal != null ? this.defaultGoal : (this.base != null ? this.base.defaultGoal : null), this.resources != null ? this.resources : (this.base != null ? this.base.resources : null), this.testResources != null ? this.testResources : (this.base != null ? this.base.testResources : null), this.directory != null ? this.directory : (this.base != null ? this.base.directory : null), this.finalName != null ? this.finalName : (this.base != null ? this.base.finalName : null), this.filters != null ? this.filters : (this.base != null ? this.base.filters : null), this.sourceDirectory != null ? this.sourceDirectory : (this.base != null ? this.base.sourceDirectory : null), this.scriptSourceDirectory != null ? this.scriptSourceDirectory : (this.base != null ? this.base.scriptSourceDirectory : null), this.testSourceDirectory != null ? this.testSourceDirectory : (this.base != null ? this.base.testSourceDirectory : null), this.outputDirectory != null ? this.outputDirectory : (this.base != null ? this.base.outputDirectory : null), this.testOutputDirectory != null ? this.testOutputDirectory : (this.base != null ? this.base.testOutputDirectory : null), this.extensions != null ? this.extensions : (this.base != null ? this.base.extensions : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), pluginsLocation != null ? pluginsLocation : (this.base != null ? this.base.pluginsLocation : null), pluginManagementLocation != null ? pluginManagementLocation : (this.base != null ? this.base.pluginManagementLocation : null), defaultGoalLocation != null ? defaultGoalLocation : (this.base != null ? this.base.defaultGoalLocation : null), resourcesLocation != null ? resourcesLocation : (this.base != null ? this.base.resourcesLocation : null), testResourcesLocation != null ? testResourcesLocation : (this.base != null ? this.base.testResourcesLocation : null), directoryLocation != null ? directoryLocation : (this.base != null ? this.base.directoryLocation : null), finalNameLocation != null ? finalNameLocation : (this.base != null ? this.base.finalNameLocation : null), filtersLocation != null ? filtersLocation : (this.base != null ? this.base.filtersLocation : null), sourceDirectoryLocation != null ? sourceDirectoryLocation : (this.base != null ? this.base.sourceDirectoryLocation : null), scriptSourceDirectoryLocation != null ? scriptSourceDirectoryLocation : (this.base != null ? this.base.scriptSourceDirectoryLocation : null), testSourceDirectoryLocation != null ? testSourceDirectoryLocation : (this.base != null ? this.base.testSourceDirectoryLocation : null), outputDirectoryLocation != null ? outputDirectoryLocation : (this.base != null ? this.base.outputDirectoryLocation : null), testOutputDirectoryLocation != null ? testOutputDirectoryLocation : (this.base != null ? this.base.testOutputDirectoryLocation : null), extensionsLocation != null ? extensionsLocation : (this.base != null ? this.base.extensionsLocation : null));
        }
    }
}

