/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient.hc5;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.transport.http.asyncclient.hc5.CXFHttpRequest;
import org.apache.cxf.transport.http.asyncclient.hc5.SharedOutputBuffer;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.protocol.HttpContext;

public class CXFHttpAsyncRequestProducer
implements AsyncRequestProducer {
    private final CXFHttpRequest request;
    private final SharedOutputBuffer buf;
    private volatile CachedOutputStream content;
    private volatile ByteBuffer buffer;
    private volatile InputStream fis;
    private volatile ReadableByteChannel chan;

    public CXFHttpAsyncRequestProducer(CXFHttpRequest request, SharedOutputBuffer buf) {
        this.buf = buf;
        this.request = request;
    }

    public void produce(DataStreamChannel channel) throws IOException {
        if (this.content != null) {
            if (this.buffer == null) {
                if (this.content.getTempFile() == null) {
                    this.buffer = ByteBuffer.wrap(this.content.getBytes());
                } else {
                    this.fis = this.content.getInputStream();
                    this.chan = this.fis instanceof FileInputStream ? ((FileInputStream)this.fis).getChannel() : Channels.newChannel(this.fis);
                    this.buffer = ByteBuffer.allocate(8192);
                }
            }
            int i = -1;
            ((Buffer)this.buffer).rewind();
            if (this.buffer.hasRemaining() && this.chan != null) {
                i = this.chan.read(this.buffer);
                this.buffer.flip();
            }
            channel.write(this.buffer);
            if (!this.buffer.hasRemaining() && i == -1) {
                channel.endStream();
            }
        } else {
            this.buf.produceContent(channel);
        }
    }

    public void failed(Exception ex) {
        this.buf.shutdown();
    }

    public boolean isRepeatable() {
        return this.request.getOutputStream().retransmitable();
    }

    private void resetRequest() {
        if (this.request.getOutputStream().retransmitable()) {
            this.content = this.request.getOutputStream().getCachedStream();
        }
    }

    public int available() {
        return 0;
    }

    public void releaseResources() {
        this.buf.close();
        if (this.fis != null) {
            try {
                this.fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.chan = null;
            this.fis = null;
        }
        this.buffer = null;
        this.resetRequest();
    }

    public void sendRequest(RequestChannel channel, HttpContext context) throws HttpException, IOException {
        channel.sendRequest((HttpRequest)this.request, (EntityDetails)this.request.getEntity(), context);
    }
}

