// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;

import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.utils.LineLocation;

public class Getenv extends SimpleReturnFunction {

	public TFunctionSignature getSignature() {
		return new TFunctionSignature("%getenv", 1);
	}

	public boolean canCover(int nbArg, Set<String> namedArgument) {
		return nbArg == 1;
	}

	public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values,
			Map<String, TValue> named) throws EaterException, EaterExceptionLocated {
		// ::comment when __CORE__
		final String value = getenv(values.get(0).toString());
		if (value == null)
			return TValue.fromString("");

		return TValue.fromString(value);

		// ::uncomment when __CORE__
		// return TValue.fromString("");
	}

	// ::comment when __CORE__
	private String getenv(String name) {
		// Check, if the script requests secret information.
		// A plantuml server should have an own SecurityManager to
		// avoid access to properties and environment variables, but we should
		// also stop here in other deployments.
		if (SecurityUtils.getSecurityProfile().canWeReadThisEnvironmentVariable(name) == false)
			return null;
		
		final String env = System.getProperty(name);
		if (env != null)
			return env;

		return System.getenv(name);
	}
}
