// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;

public class CircleInterface2 extends AbstractTextBlock implements TextBlock {

	private final double margin = 1;

	private final double radius = 8;

	private final HColor backgroundColor;
	private final HColor foregroundColor;

	private final double deltaShadow;

	public CircleInterface2(HColor backgroundColor, HColor foregroundColor, double deltaShadow) {
		this.backgroundColor = backgroundColor;
		this.foregroundColor = foregroundColor;
		this.deltaShadow = deltaShadow;
	}

	public void drawU(UGraphic ug) {
		double x = 0;
		double y = 0;
		x += margin;
		y += margin;
		ug = ug.apply(backgroundColor.bg()).apply(foregroundColor);
		final UEllipse circle = UEllipse.build(radius * 2, radius * 2);
		circle.setDeltaShadow(deltaShadow);
		ug.apply(new UTranslate(x, y)).draw(circle);
	}

	public XDimension2D calculateDimension(StringBounder stringBounder) {
		return new XDimension2D(radius * 2 + 2 * margin, radius * 2 + 2 * margin);
	}

}
