// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.security.authentication.oauth;

import java.util.Arrays;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.security.authentication.SecurityAuthentication;
import net.sourceforge.plantuml.security.authentication.SecurityCredentials;
import net.sourceforge.plantuml.security.authentication.basicauth.BasicAuthAuthorizeManager;

/**
 * Authorize via principal a resource owner (from {@link SecurityCredentials}
 * and creates a {@link SecurityAuthentication} object with a bearer token
 * secret.
 * <p>
 * Because a pass through of username/password is an anti-pattern in OAuth2,
 * this authorization method should be avoided. However, it may be necessary in
 * some environments to gain access with the ROPC flow.
 *
 * @author Aljoscha Rittner
 */
public class OAuth2ResourceOwnerAccessAuthorizeManager extends AbstractOAuth2AccessAuthorizeManager {

	/**
	 * Basic Auth manager to access the token service with authorization.
	 */
	private final BasicAuthAuthorizeManager basicAuthManager = new BasicAuthAuthorizeManager();

	@Override
	public SecurityAuthentication create(SecurityCredentials credentials) {
		String grantType = credentials.getPropertyStr("grantType");
		String requestScope = credentials.getPropertyStr("scope");
		String accessTokenUri = credentials.getPropertyStr("accessTokenUri");
		String tokenType = credentials.getPropertyStr("tokenType");

		// Resource owner
		String username = credentials.getPropertyStr("resourceOwner.identifier");
		char[] password = credentials.getPropertyChars("resourceOwner.secret");

		try {
			SURL tokenService = SURL.create(accessTokenUri);

			StringBuilder content = new StringBuilder().append("grant_type=").append(urlEncode(grantType));
			if (StringUtils.isNotEmpty(requestScope)) {
				content.append("&scope=").append(urlEncode(requestScope));
			}

			// OAuth2 with BasicAuth via principal (standard)
			SecurityAuthentication basicAuth = basicAuthManager
					.create(SecurityCredentials.basicAuth(credentials.getIdentifier(), credentials.getSecret()));
			// We need to add the principal to the form
			content.append("&username=").append(urlEncode(username)).append("&password=")
					.append(urlEncode(new String(password)));

			return requestAndCreateAuthFromResponse(credentials.getProxy(), grantType, tokenType, tokenService,
					content.toString(), basicAuth);
		} finally {
			if (password != null && password.length > 0) {
				Arrays.fill(password, '*');
			}
		}
	}

}
