// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.Collections;
import java.util.List;

import net.sourceforge.plantuml.klimt.creole.Neutron;
import net.sourceforge.plantuml.klimt.creole.Parser;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.atom.AtomMath;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.math.ScientificEquationSafe;

public class StripeLatex implements StripeRaw {
	// ::remove file when __CORE__
	final private FontConfiguration fontConfiguration;
	final private StringBuilder formula = new StringBuilder();
	private AtomMath atom;

	private boolean terminated;

	public StripeLatex(FontConfiguration fontConfiguration) {
		this.fontConfiguration = fontConfiguration;
	}

	public List<Atom> getAtoms() {
		return Collections.<Atom>singletonList(this);
	}

	public Atom getLHeader() {
		return null;
	}

	@Override
	public boolean addAndCheckTermination(String line) {
		if (Parser.isLatexEnd(line)) {
			this.terminated = true;
			return true;
		}
		this.formula.append(line);
		return false;
	}

	@Override
	public final boolean isTerminated() {
		return terminated;
	}

	private Atom getAtom() {
		if (atom == null) {
			final ScientificEquationSafe math = ScientificEquationSafe.fromLatex(formula.toString());
			atom = new AtomMath(math, fontConfiguration.getColor(), fontConfiguration.getExtendedColor());
		}
		return atom;
	}

	public XDimension2D calculateDimension(StringBounder stringBounder) {
		return getAtom().calculateDimension(stringBounder);
	}

	public double getStartingAltitude(StringBounder stringBounder) {
		return 0;
	}

	public void drawU(UGraphic ug) {
		getAtom().drawU(ug);
	}

	@Override
	public List<Neutron> getNeutrons() {
		throw new UnsupportedOperationException();
	}

}
