// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.eggs;

import java.math.BigInteger;

import net.sourceforge.plantuml.StringUtils;

public class EggUtils {
	// ::remove file when __CORE__

	public static String fromByteArrays(byte data[]) {
		final StringBuilder sb = new StringBuilder();
		for (byte b : data) {
			final String hex = Integer.toHexString(b & 0xFF);
			if (hex.length() == 1)
				sb.append('0');

			sb.append(hex);
		}
		return sb.toString();
	}

	public static byte[] toByteArrays(String s) {
		final byte[] result = new byte[s.length() / 2];
		for (int i = 0; i < result.length; i++)
			result[i] = (byte) Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);

		return result;
	}

	public static BigInteger fromSecretSentence(String s) {
		BigInteger result = BigInteger.ZERO;
		final BigInteger twentySix = BigInteger.valueOf(26);
		s = s.replace('\u00E9', 'e');
		s = s.replace('\u00EA', 'e');
		for (char c : s.toCharArray()) {
			final int num = convertChar(c);
			if (num != -1) {
				result = result.multiply(twentySix);
				result = result.add(BigInteger.valueOf(num));
			}
		}
		return result;

	}

	private static int convertChar(char c) {
		c = StringUtils.goLowerCase(c);
		if (c >= 'a' && c <= 'z')
			return c - 'a';
		return -1;
	}

	public static byte[] xor(byte data[], byte key[]) {
		final byte[] result = new byte[data.length];
		int pos = 0;
		for (int i = 0; i < result.length; i++) {
			result[i] = (byte) (data[i] ^ key[pos++]);
			if (pos == key.length)
				pos = 0;
		}
		return result;
	}

}
