// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.cucadiagram;

import java.io.IOException;
import java.io.PrintWriter;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;

public class GroupPrinter {
	// ::remove file when __CORE__

	private final PrintWriter pw;

	private GroupPrinter(PrintWriter pw) {
		this.pw = pw;
	}

	private void printGroup(Entity group) {
		pw.println("<table border=1 cellpadding=8 cellspacing=0>");
		pw.println("<tr>");
		pw.println("<td bgcolor=#DDDDDD>");
		pw.println(group.getName());
		pw.println("<tr>");
		pw.println("<td>");
		if (group.leafs().size() == 0) {
			pw.println("<i>No direct leaf</i>");
		} else {
			for (Entity leaf : group.leafs()) {
				pw.println("<ul>");
				printLeaf(leaf);
				pw.println("</ul>");
			}
		}
		pw.println("</td>");
		pw.println("</tr>");
		if (group.groups().size() > 0) {
			pw.println("<tr>");
			pw.println("<td>");
			for (Entity g : group.groups()) {
				pw.println("<br>");
				printGroup(g);
				pw.println("<br>");
			}
			pw.println("</td>");
			pw.println("</tr>");
		}
		pw.println("</table>");
	}

	private void printLeaf(Entity leaf) {
		pw.println("<li>" + leaf.getName());
	}

	public static void print(SFile f, Entity rootGroup) {
		try (PrintWriter pw = f.createPrintWriter()) {
			pw.println("<html>");
			new GroupPrinter(pw).printGroup(rootGroup);
			pw.println("</html>");
		} catch (IOException e) {
			Logme.error(e);
		}
	}

}
