// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;

public class SkinLoader {

	public final static Pattern2 p1 = MyPattern
			.cmpile("^([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*)[%s]+(?:(\\{)|(.*))$|^\\}?$");

	final private List<String> context = new ArrayList<>();
	final private TitledDiagram diagram;

	public SkinLoader(TitledDiagram diagram) {
		this.diagram = diagram;
	}

	private void push(String s) {
		context.add(s);
	}

	private void pop() {
		context.remove(context.size() - 1);
	}

	private String getFullParam() {
		final StringBuilder sb = new StringBuilder();
		for (String s : context) {
			sb.append(s);
		}
		return sb.toString();
	}

	public CommandExecutionResult execute(BlocLines lines, final String group1) {

		if (group1 != null) {
			this.push(group1);
		}

		try {

			lines = lines.subExtract(1, 1);
			lines = lines.trim().removeEmptyLines();

			for (StringLocated s : lines) {
				assert s.getString().length() > 0;

				if (s.getString().equals("}")) {
					this.pop();
					continue;
				}
				final Matcher2 m = p1.matcher(s.getString());
				if (m.find() == false) {
					throw new IllegalStateException();
				}
				if (m.group(2) != null) {
					this.push(m.group(1));
				} else if (m.group(3) != null) {
					final String key = this.getFullParam() + m.group(1);
					diagram.setParam(key, m.group(3));
				} else {
					throw new IllegalStateException("." + s.getString() + ".");
				}
			}
			return CommandExecutionResult.ok();
		} catch (NoStyleAvailableException e) {
			// Logme.error(e);
			return CommandExecutionResult.error("General failure: no style available.");
		}

	}

}
