// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.asciiart;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.txt.UGraphicTxt;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;

public class ComponentTextParticipant extends AbstractComponentText {

	private final ComponentType type;
	private final Display stringsToDisplay;
	private final FileFormat fileFormat;

	public ComponentTextParticipant(ComponentType type, Display stringsToDisplay, FileFormat fileFormat) {
		this.type = type;
		this.stringsToDisplay = stringsToDisplay;
		this.fileFormat = fileFormat;
	}

	public void drawU(UGraphic ug, Area area, Context2D context) {
		final XDimension2D dimensionToUse = area.getDimensionToUse();
		final UmlCharArea charArea = ((UGraphicTxt) ug).getCharArea();
		final int width = (int) dimensionToUse.getWidth();
		final int height = (int) dimensionToUse.getHeight();
		charArea.fillRect(' ', 0, 0, width, height);
		if (fileFormat == FileFormat.UTXT) {
			charArea.drawBoxSimpleUnicode(0, 0, width, height);
			if (type == ComponentType.PARTICIPANT_TAIL) {
				charArea.drawChar('\u2534', (width - 1) / 2, 0);
			}
			if (type == ComponentType.PARTICIPANT_HEAD) {
				charArea.drawChar('\u252c', (width - 1) / 2, height - 1);
			}
		} else {
			charArea.drawBoxSimple(0, 0, width, height);
			if (type == ComponentType.PARTICIPANT_TAIL) {
				charArea.drawChar('+', (width - 1) / 2, 0);
			}
			if (type == ComponentType.PARTICIPANT_HEAD) {
				charArea.drawChar('+', (width - 1) / 2, height - 1);
			}
		}
		if (fileFormat == FileFormat.UTXT) {
			charArea.drawStringsLRUnicode(stringsToDisplay.asList(), 1, 1);
		} else {
			charArea.drawStringsLRSimple(stringsToDisplay.asList(), 1, 1);
		}
	}

	public double getPreferredHeight(StringBounder stringBounder) {
		return StringUtils.getHeight(stringsToDisplay) + 2;
	}

	public double getPreferredWidth(StringBounder stringBounder) {
		return StringUtils.getWcWidth(stringsToDisplay) + 2;
	}

}
