/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj;

import com.saxonica.xqj.SaxonXQDataFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;

public class SaxonXQItemType
implements XQItemType {
    private final ItemType itemType;
    private final Configuration config;

    protected SaxonXQItemType(ItemType itemType, Configuration config) {
        this.itemType = itemType;
        this.config = config;
    }

    protected SaxonXQItemType(NodeInfo node) {
        this.config = node.getConfiguration();
        this.itemType = Type.getItemType((Item)node, (TypeHierarchy)this.config.getTypeHierarchy());
    }

    @Override
    public int getBaseType() throws XQException {
        if (this.itemType instanceof AtomicType) {
            AtomicType at = (AtomicType)this.itemType;
            while (!at.isBuiltInType()) {
                at = (AtomicType)at.getBaseType();
            }
            return SaxonXQDataFactory.mapSaxonTypeToXQJ(at.getFingerprint());
        }
        if (this.itemType instanceof NodeTest) {
            NodeTest it = (NodeTest)this.itemType;
            if (it instanceof DocumentNodeTest) {
                it = ((DocumentNodeTest)it).getElementTest();
            }
            if (it.getUType().overlaps(UType.TEXT.union(UType.DOCUMENT).union(UType.COMMENT).union(UType.PI).union(UType.NAMESPACE))) {
                throw new XQException("Wrong node kind for getBaseType()");
            }
            SchemaType contentType = it.getContentType();
            if (contentType.isAtomicType()) {
                AtomicType at = (AtomicType)contentType;
                while (!at.isBuiltInType()) {
                    at = (AtomicType)at.getBaseType();
                }
                return SaxonXQDataFactory.mapSaxonTypeToXQJ(at.getFingerprint());
            }
            if (contentType.isSimpleType()) {
                if (((SimpleType)contentType).isListType()) {
                    int fp = contentType.getFingerprint();
                    if (fp == 557) {
                        return 51;
                    }
                    if (fp == 564) {
                        return 50;
                    }
                    if (fp == 562) {
                        return 49;
                    }
                }
                return 3;
            }
            if (contentType == Untyped.getInstance()) {
                return 1;
            }
            return 2;
        }
        throw new XQException("Wrong item type for getBaseType()");
    }

    @Override
    public int getItemKind() {
        if (this.itemType instanceof AtomicType) {
            return 1;
        }
        if (this.itemType instanceof NodeTest) {
            if (this.itemType instanceof DocumentNodeTest) {
                return 5;
            }
            int x = this.itemType.getPrimitiveType();
            switch (x) {
                case 9: {
                    return 4;
                }
                case 1: {
                    return 7;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 11;
                }
                case 8: {
                    return 3;
                }
                case 7: {
                    return 10;
                }
                case 0: {
                    return 9;
                }
            }
        }
        return 8;
    }

    @Override
    public int getItemOccurrence() {
        return 2;
    }

    @Override
    public QName getNodeName() throws XQException {
        ItemType type = this.itemType;
        if (type instanceof DocumentNodeTest) {
            type = ((DocumentNodeTest)type).getElementTest();
        }
        if (type instanceof NodeTest) {
            if (type.getUType().overlaps(UType.TEXT.union(UType.DOCUMENT).union(UType.COMMENT).union(UType.PI).union(UType.NAMESPACE))) {
                throw new XQException("Wrong node kind for getNodeName()");
            }
            StructuredQName match = ((NodeTest)type).getMatchingNodeName();
            if (match != null) {
                return new QName(match.getNamespaceUri().toString(), match.getLocalPart());
            }
            return null;
        }
        throw new XQException("getNodeName() is not defined for this kind of item type");
    }

    @Override
    public String getPIName() throws XQException {
        if (this.itemType instanceof NameTest && this.itemType.getPrimitiveType() == 7) {
            StructuredQName match = ((NameTest)this.itemType).getMatchingNodeName();
            return match.getLocalPart();
        }
        if (this.itemType instanceof NodeKindTest && this.itemType.getPrimitiveType() == 7) {
            return null;
        }
        throw new XQException("Item kind is not a processing instruction");
    }

    @Override
    public URI getSchemaURI() {
        try {
            if (this.itemType instanceof NodeTest) {
                SchemaType content = ((NodeTest)this.itemType).getContentType();
                if (content == null) {
                    return null;
                }
                String systemId = content.getSystemId();
                if (systemId == null) {
                    return null;
                }
                return new URI(systemId);
            }
            if (this.itemType instanceof AtomicType) {
                String systemId = ((AtomicType)this.itemType).getSystemId();
                return systemId == null ? null : new URI(systemId);
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.itemType.toString();
    }

    @Override
    public QName getTypeName() throws XQException {
        ItemType type = this.itemType;
        if (type instanceof AtomicType) {
            StructuredQName name = ((AtomicType)type).getStructuredQName();
            return new QName(name.getNamespaceUri().toString(), name.getLocalPart());
        }
        if (type instanceof DocumentNodeTest) {
            type = ((DocumentNodeTest)type).getElementTest();
        }
        if (type instanceof NodeTest) {
            if (type.getUType().overlaps(UType.TEXT.union(UType.DOCUMENT).union(UType.COMMENT).union(UType.PI).union(UType.NAMESPACE))) {
                throw new XQException("getTypeName() failed: itemType is not a document, element, or attribute test");
            }
            SchemaType t = ((NodeTest)type).getContentType();
            if (t != null) {
                StructuredQName name = ((NodeTest)type).getContentType().getStructuredQName();
                return new QName(name.getNamespaceUri().toString(), name.getLocalPart());
            }
        }
        throw new XQException("getTypeName() failed: itemType is not a document, element, or attribute test");
    }

    @Override
    public boolean isAnonymousType() {
        SchemaType t;
        ItemType type = this.itemType;
        if (type instanceof DocumentNodeTest) {
            type = ((DocumentNodeTest)type).getElementTest();
        }
        if (type instanceof NodeTest && (t = ((NodeTest)type).getContentType()) != null) {
            return t.isAnonymousType();
        }
        return false;
    }

    @Override
    public boolean isElementNillable() {
        return this.itemType instanceof NodeTest && this.itemType.getUType() == UType.ELEMENT && ((NodeTest)this.itemType).isNillable();
    }

    @Override
    public XQItemType getItemType() {
        return this;
    }

    AtomicType getAtomicType() {
        if (this.itemType instanceof AtomicType) {
            return (AtomicType)this.itemType;
        }
        return null;
    }

    ItemType getSaxonItemType() {
        return this.itemType;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SaxonXQItemType && this.itemType.equals((Object)((SaxonXQItemType)obj).itemType);
    }

    @Override
    public int hashCode() {
        return this.itemType.hashCode();
    }
}

