////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2018-2022 Saxonica Limited
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/.
// This Source Code Form is "Incompatible With Secondary Licenses", as defined by the Mozilla Public License, v. 2.0.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * <p>This package provides classes associated with XSLT pattern handling. </p>
 * <p>The principal classes are:</p>
 * <p><b>Pattern</b>:<br>
 * This represents an XSLT Pattern. There is a static method Pattern.make() which is
 * used to construct a Pattern from a String (it is a factory method rather than a
 * constructor, because it typically returns some subclass of Pattern according
 * to the syntax supplied). Subclasses of Pattern represent different kinds of pattern
 * such as LocationPathPattern and IDKeyPattern. What they all have in common is a match()
 * method, which determines whether a given node matches the pattern. A pattern is
 * not in itself an Expression, but the class <code>PatternSponsor</code> is used
 * to wrap a pattern making it look like an expression for the benefit of the static analysis
 * (allowing the same mechanisms to be used for example to find all the references to a variable).</p>
 * <p><b>NodeTest</b>:<br>
 * This represents a NodeTest within a step of an XPath expression. A NodeTest performs several
 * roles: as well as its use in conjuction with an axis to form a step of a path expression,
 * it acts as an ItemType used in handling type checking of nodes, and (wrapped in a NodeTestPattern)
 * it acts as an XSLT pattern for use in constructs such as the <code>match</code> attribute of
 * <code>xsl:template</code> and <code>xsl:key</code>.
 * A NodeTest is used directly to implement simple patterns such as <code>match="item"</code>
 * or <code>match="*"</code>. There are several subclasses of NodeTest, depending on the conditions
 * to be matched: node type, node name, namespace URI, and so on. The class AnyNodeTest matches any node,
 * while NoNodeTest matches nothing. NodeTests can also be combined using the operators of intersection,
 * difference, and union, to describe the more complex types that are sometimes computed by the type
 * checking machinery.</p>
 */
package net.sf.saxon.pattern;
