/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import net.masterthought.cucumber.json.deserializers.EmbeddingDeserializer;

@JsonDeserialize(using=EmbeddingDeserializer.class)
public class Embedding {
    private static final String FILE_EXTENSION_PATTERN = "[a-z0-9]+";
    private static final String UNKNOWN_FILE_EXTENSION = "unknown";
    private final String mimeType;
    private final String data;
    private final String name;
    private final String fileId;

    public Embedding(String mimeType, String data) {
        this(mimeType, data, null);
    }

    public Embedding(String mimeType, String data, String name) {
        this.mimeType = mimeType;
        this.data = data;
        this.name = name;
        this.fileId = "embedding_" + data.hashCode();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public String getDecodedData() {
        return new String(Base64.getDecoder().decode(this.data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public String getFileName() {
        return this.fileId + "." + this.getExtension();
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getExtension() {
        String subtype;
        String extension;
        String mime = this.mimeType;
        if (mime.contains("+")) {
            mime = mime.substring(0, mime.indexOf(43));
        }
        if (mime.contains(";")) {
            mime = mime.substring(0, mime.indexOf(59));
        }
        switch (mime = mime.toLowerCase(Locale.ENGLISH).trim()) {
            case "image/url": {
                return "image";
            }
            case "text/plain": {
                return "txt";
            }
            case "application/ecmascript": {
                return "es";
            }
            case "application/javascript": {
                return "js";
            }
            case "application/x-tar": {
                return "tar";
            }
            case "application/x-bzip2": {
                return "bz2";
            }
            case "application/gzip": {
                return "gz";
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
                return "xlsx";
            }
            case "application/vnd.ms-excel": {
                return "xls";
            }
        }
        if (this.name != null && this.name.contains(".") && (extension = this.name.substring(this.name.lastIndexOf(46) + 1)).matches(FILE_EXTENSION_PATTERN)) {
            return extension;
        }
        if (mime.contains("/") && (subtype = mime.substring(mime.indexOf(47) + 1)).matches(FILE_EXTENSION_PATTERN)) {
            return subtype;
        }
        return UNKNOWN_FILE_EXTENSION;
    }
}

