/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import tools.jackson.core.JsonGenerator;

public class StackTraceJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_STACK_TRACE = "stack_trace";
    private ThrowableHandlingConverter throwableConverter = new ExtendedThrowableProxyConverter();
    private boolean writeAsArray;

    public StackTraceJsonProvider() {
        this.setFieldName(FIELD_STACK_TRACE);
    }

    @Override
    public void start() {
        this.throwableConverter.start();
        super.start();
    }

    @Override
    public void stop() {
        this.throwableConverter.stop();
        super.stop();
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy == null) {
            return;
        }
        String stacktrace = this.throwableConverter.convert((Object)event);
        if (this.writeAsArray) {
            String[] lines = stacktrace.split("\n");
            JsonWritingUtils.writeStringArrayField(generator, this.getFieldName(), lines);
        } else {
            JsonWritingUtils.writeStringField(generator, this.getFieldName(), stacktrace);
        }
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getStackTrace());
    }

    public ThrowableHandlingConverter getThrowableConverter() {
        return this.throwableConverter;
    }

    public void setThrowableConverter(ThrowableHandlingConverter throwableConverter) {
        this.throwableConverter = throwableConverter;
    }

    public boolean isWriteAsArray() {
        return this.writeAsArray;
    }

    public void setWriteAsArray(boolean writeAsArray) {
        this.writeAsArray = writeAsArray;
    }
}

