/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.messaging.ConsumerRequest;
import brave.propagation.Propagation;
import brave.spring.rabbit.MessageHeaders;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

final class MessageConsumerRequest
extends ConsumerRequest {
    static final Propagation.RemoteGetter<MessageConsumerRequest> GETTER = new Propagation.RemoteGetter<MessageConsumerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.CONSUMER;
        }

        public String get(MessageConsumerRequest request, String name) {
            return MessageHeaders.getHeaderIfString(request.delegate, name);
        }

        public String toString() {
            return "MessageProperties::getHeader";
        }
    };
    static final Propagation.RemoteSetter<MessageConsumerRequest> SETTER = new Propagation.RemoteSetter<MessageConsumerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.CONSUMER;
        }

        public void put(MessageConsumerRequest request, String name, String value) {
            MessageHeaders.setHeader(request.delegate, name, value);
        }

        public String toString() {
            return "MessageProperties::setHeader";
        }
    };
    final Message delegate;

    MessageConsumerRequest(Message delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public Span.Kind spanKind() {
        return Span.Kind.CONSUMER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "receive";
    }

    public String channelKind() {
        return "queue";
    }

    public String channelName() {
        MessageProperties properties = this.delegate.getMessageProperties();
        return properties != null ? properties.getConsumerQueue() : null;
    }
}

