/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package io.opentelemetry.semconv.incubating;

import static io.opentelemetry.api.common.AttributeKey.stringKey;

import io.opentelemetry.api.common.AttributeKey;

// DO NOT EDIT, this is an Auto-generated file from
// buildscripts/templates/registry/incubating_java/IncubatingSemanticAttributes.java.j2
@SuppressWarnings("unused")
public final class VcsIncubatingAttributes {
  /**
   * The ID of the change (pull request/merge request/changelist) if applicable. This is usually a
   * unique (within repository) identifier generated by the VCS system.
   */
  public static final AttributeKey<String> VCS_CHANGE_ID = stringKey("vcs.change.id");

  /** The state of the change (pull request/merge request/changelist). */
  public static final AttributeKey<String> VCS_CHANGE_STATE = stringKey("vcs.change.state");

  /**
   * The human readable title of the change (pull request/merge request/changelist). This title is
   * often a brief summary of the change and may get merged in to a ref as the commit summary.
   */
  public static final AttributeKey<String> VCS_CHANGE_TITLE = stringKey("vcs.change.title");

  /** The type of line change being measured on a branch or change. */
  public static final AttributeKey<String> VCS_LINE_CHANGE_TYPE = stringKey("vcs.line_change.type");

  /**
   * The name of the <a href="https://git-scm.com/docs/gitglossary#def_ref">reference</a> such as
   * <strong>branch</strong> or <strong>tag</strong> in the repository.
   */
  public static final AttributeKey<String> VCS_REF_BASE_NAME = stringKey("vcs.ref.base.name");

  /**
   * The revision, literally <a href="https://www.merriam-webster.com/dictionary/revision">revised
   * version</a>, The revision most often refers to a commit object in Git, or a revision number in
   * SVN.
   *
   * <p>Notes:
   *
   * <p>The revision can be a full <a
   * href="https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-5.pdf">hash value (see
   * glossary)</a>, of the recorded change to a ref within a repository pointing to a commit <a
   * href="https://git-scm.com/docs/git-commit">commit</a> object. It does not necessarily have to
   * be a hash; it can simply define a <a
   * href="https://svnbook.red-bean.com/en/1.7/svn.tour.revs.specifiers.html">revision number</a>
   * which is an integer that is monotonically increasing. In cases where it is identical to the
   * {@code ref.base.name}, it SHOULD still be included. It is up to the implementer to decide which
   * value to set as the revision based on the VCS system and situational context.
   */
  public static final AttributeKey<String> VCS_REF_BASE_REVISION =
      stringKey("vcs.ref.base.revision");

  /**
   * The type of the <a href="https://git-scm.com/docs/gitglossary#def_ref">reference</a> in the
   * repository.
   */
  public static final AttributeKey<String> VCS_REF_BASE_TYPE = stringKey("vcs.ref.base.type");

  /**
   * The name of the <a href="https://git-scm.com/docs/gitglossary#def_ref">reference</a> such as
   * <strong>branch</strong> or <strong>tag</strong> in the repository.
   */
  public static final AttributeKey<String> VCS_REF_HEAD_NAME = stringKey("vcs.ref.head.name");

  /**
   * The revision, literally <a href="https://www.merriam-webster.com/dictionary/revision">revised
   * version</a>, The revision most often refers to a commit object in Git, or a revision number in
   * SVN.
   *
   * <p>Notes:
   *
   * <p>The revision can be a full <a
   * href="https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-5.pdf">hash value (see
   * glossary)</a>, of the recorded change to a ref within a repository pointing to a commit <a
   * href="https://git-scm.com/docs/git-commit">commit</a> object. It does not necessarily have to
   * be a hash; it can simply define a <a
   * href="https://svnbook.red-bean.com/en/1.7/svn.tour.revs.specifiers.html">revision number</a>
   * which is an integer that is monotonically increasing. In cases where it is identical to the
   * {@code ref.head.name}, it SHOULD still be included. It is up to the implementer to decide which
   * value to set as the revision based on the VCS system and situational context.
   */
  public static final AttributeKey<String> VCS_REF_HEAD_REVISION =
      stringKey("vcs.ref.head.revision");

  /**
   * The type of the <a href="https://git-scm.com/docs/gitglossary#def_ref">reference</a> in the
   * repository.
   */
  public static final AttributeKey<String> VCS_REF_HEAD_TYPE = stringKey("vcs.ref.head.type");

  /**
   * The type of the <a href="https://git-scm.com/docs/gitglossary#def_ref">reference</a> in the
   * repository.
   */
  public static final AttributeKey<String> VCS_REF_TYPE = stringKey("vcs.ref.type");

  /**
   * Deprecated, use {@code vcs.change.id} instead.
   *
   * <p>
   *
   * @deprecated Deprecated, use {@code vcs.change.id} instead.
   */
  @Deprecated
  public static final AttributeKey<String> VCS_REPOSITORY_CHANGE_ID =
      stringKey("vcs.repository.change.id");

  /**
   * Deprecated, use {@code vcs.change.title} instead.
   *
   * <p>
   *
   * @deprecated Deprecated, use {@code vcs.change.title} instead.
   */
  @Deprecated
  public static final AttributeKey<String> VCS_REPOSITORY_CHANGE_TITLE =
      stringKey("vcs.repository.change.title");

  /**
   * Deprecated, use {@code vcs.ref.head.name} instead.
   *
   * <p>
   *
   * @deprecated Deprecated, use {@code vcs.ref.head.name} instead.
   */
  @Deprecated
  public static final AttributeKey<String> VCS_REPOSITORY_REF_NAME =
      stringKey("vcs.repository.ref.name");

  /**
   * Deprecated, use {@code vcs.ref.head.revision} instead.
   *
   * <p>
   *
   * @deprecated Deprecated, use {@code vcs.ref.head.revision} instead.
   */
  @Deprecated
  public static final AttributeKey<String> VCS_REPOSITORY_REF_REVISION =
      stringKey("vcs.repository.ref.revision");

  /**
   * Deprecated, use {@code vcs.ref.head.type} instead.
   *
   * <p>
   *
   * @deprecated Deprecated, use {@code vcs.ref.head.type} instead.
   */
  @Deprecated
  public static final AttributeKey<String> VCS_REPOSITORY_REF_TYPE =
      stringKey("vcs.repository.ref.type");

  /**
   * The <a href="https://wikipedia.org/wiki/URL">URL</a> of the repository providing the complete
   * address in order to locate and identify the repository.
   */
  public static final AttributeKey<String> VCS_REPOSITORY_URL_FULL =
      stringKey("vcs.repository.url.full");

  /** The type of revision comparison. */
  public static final AttributeKey<String> VCS_REVISION_DELTA_DIRECTION =
      stringKey("vcs.revision_delta.direction");

  // Enum definitions
  /** Values for {@link #VCS_CHANGE_STATE}. */
  public static final class VcsChangeStateIncubatingValues {
    /**
     * Open means the change is currently active and under review. It hasn't been merged into the
     * target branch yet, and it's still possible to make changes or add comments.
     */
    public static final String OPEN = "open";

    /**
     * WIP (work-in-progress, draft) means the change is still in progress and not yet ready for a
     * full review. It might still undergo significant changes.
     */
    public static final String WIP = "wip";

    /**
     * Closed means the merge request has been closed without merging. This can happen for various
     * reasons, such as the changes being deemed unnecessary, the issue being resolved in another
     * way, or the author deciding to withdraw the request.
     */
    public static final String CLOSED = "closed";

    /**
     * Merged indicates that the change has been successfully integrated into the target codebase.
     */
    public static final String MERGED = "merged";

    private VcsChangeStateIncubatingValues() {}
  }

  /** Values for {@link #VCS_LINE_CHANGE_TYPE}. */
  public static final class VcsLineChangeTypeIncubatingValues {
    /** How many lines were added. */
    public static final String ADDED = "added";

    /** How many lines were removed. */
    public static final String REMOVED = "removed";

    private VcsLineChangeTypeIncubatingValues() {}
  }

  /** Values for {@link #VCS_REF_BASE_TYPE}. */
  public static final class VcsRefBaseTypeIncubatingValues {
    /**
     * <a
     * href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddefbranchabranch">branch</a>
     */
    public static final String BRANCH = "branch";

    /**
     * <a
     * href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddeftagatag">tag</a>
     */
    public static final String TAG = "tag";

    private VcsRefBaseTypeIncubatingValues() {}
  }

  /** Values for {@link #VCS_REF_HEAD_TYPE}. */
  public static final class VcsRefHeadTypeIncubatingValues {
    /**
     * <a
     * href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddefbranchabranch">branch</a>
     */
    public static final String BRANCH = "branch";

    /**
     * <a
     * href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddeftagatag">tag</a>
     */
    public static final String TAG = "tag";

    private VcsRefHeadTypeIncubatingValues() {}
  }

  /** Values for {@link #VCS_REF_TYPE}. */
  public static final class VcsRefTypeIncubatingValues {
    /**
     * <a
     * href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddefbranchabranch">branch</a>
     */
    public static final String BRANCH = "branch";

    /**
     * <a
     * href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddeftagatag">tag</a>
     */
    public static final String TAG = "tag";

    private VcsRefTypeIncubatingValues() {}
  }

  /**
   * Values for {@link #VCS_REPOSITORY_REF_TYPE}
   *
   * @deprecated Deprecated, use {@code vcs.ref.head.type} instead.
   */
  @Deprecated
  public static final class VcsRepositoryRefTypeIncubatingValues {
    /**
     * <a
     * href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddefbranchabranch">branch</a>
     */
    public static final String BRANCH = "branch";

    /**
     * <a
     * href="https://git-scm.com/docs/gitglossary#Documentation/gitglossary.txt-aiddeftagatag">tag</a>
     */
    public static final String TAG = "tag";

    private VcsRepositoryRefTypeIncubatingValues() {}
  }

  /** Values for {@link #VCS_REVISION_DELTA_DIRECTION}. */
  public static final class VcsRevisionDeltaDirectionIncubatingValues {
    /** How many revisions the change is behind the target ref. */
    public static final String BEHIND = "behind";

    /** How many revisions the change is ahead of the target ref. */
    public static final String AHEAD = "ahead";

    private VcsRevisionDeltaDirectionIncubatingValues() {}
  }

  private VcsIncubatingAttributes() {}
}
