/*
 * Decompiled with CFR 0.152.
 */
package io.milton.sso;

import io.milton.common.Path;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import io.milton.sso.SsoSessionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(SsoResourceFactory.class);
    private final ResourceFactory resourceFactory;
    private final SsoSessionProvider ssoSessionProvider;

    public SsoResourceFactory(ResourceFactory resourceFactory, SsoSessionProvider ssoSessionProvider) {
        this.resourceFactory = resourceFactory;
        this.ssoSessionProvider = ssoSessionProvider;
    }

    public Resource getResource(String host, String url) throws NotAuthorizedException, BadRequestException {
        Path p = Path.path((String)url);
        String firstComp = p.getFirst();
        Object oUserTag = null;
        if (firstComp != null) {
            oUserTag = this.ssoSessionProvider.getUserTag(firstComp);
        }
        if (oUserTag == null) {
            log.trace("not a SSO path");
            return this.resourceFactory.getResource(host, url);
        }
        log.trace("is an SSO path");
        Path strippedPath = p.getStripFirst();
        HttpManager.request().getAttributes().put("_sso_user", oUserTag);
        return this.resourceFactory.getResource(host, strippedPath.toString());
    }
}

