/*
 * Decompiled with CFR 0.152.
 */
package io.milton.sso;

import io.milton.sso.SsoSessionProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class ServletSsoSessionProvider
implements SsoSessionProvider,
HttpSessionListener {
    private static final Map<String, HttpSession> mapOfSessions = new ConcurrentHashMap<String, HttpSession>();
    private String userSessionVariableName = "user";

    @Override
    public Object getUserTag(String firstComp) {
        HttpSession sess = mapOfSessions.get(firstComp);
        if (sess == null) {
            return null;
        }
        return sess.getAttribute(this.userSessionVariableName);
    }

    public void sessionCreated(HttpSessionEvent hse) {
        String id = hse.getSession().getId();
        mapOfSessions.put(id, hse.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        String id = hse.getSession().getId();
        mapOfSessions.remove(id);
    }

    public String getUserSessionVariableName() {
        return this.userSessionVariableName;
    }

    public void setUserSessionVariableName(String userSessionVariableName) {
        this.userSessionVariableName = userSessionVariableName;
    }
}

