/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav2;

import io.milton.common.NameSpace;
import io.milton.http.Handler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpExtension;
import io.milton.http.HttpManager;
import io.milton.http.LockToken;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.http11.CustomPostHandler;
import io.milton.http.webdav.PropertyMap;
import io.milton.http.webdav.SupportedLocks;
import io.milton.http.webdav.UserAgentHelper;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.http.webdav2.LockHandler;
import io.milton.http.webdav2.UnlockHandler;
import io.milton.property.PropertySource;
import io.milton.resource.LockableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDavLevel2Protocol
implements HttpExtension,
PropertySource {
    private static final Logger log = LoggerFactory.getLogger(WebDavLevel2Protocol.class);
    public static final String DAV_URI = "DAV:";
    public static final String DAV_PREFIX = "d";
    public static final NameSpace NS_DAV = new NameSpace("DAV:", "d");
    private final Set<Handler> handlers;
    private final PropertyMap propertyMap;
    private final UserAgentHelper userAgentHelper;
    private List<CustomPostHandler> customPostHandlers;

    public WebDavLevel2Protocol(HandlerHelper handlerHelper, WebDavResponseHandler responseHandler, ResourceHandlerHelper resourceHandlerHelper, UserAgentHelper userAgentHelper) {
        this.userAgentHelper = userAgentHelper;
        this.propertyMap = new PropertyMap(WebDavProtocol.NS_DAV.getName());
        this.propertyMap.add((PropertyMap.StandardProperty)new SupportedLockPropertyWriter());
        this.propertyMap.add((PropertyMap.StandardProperty)new LockDiscoveryPropertyWriter());
        this.handlers = new HashSet<Handler>();
        this.handlers.add((Handler)new LockHandler(responseHandler, handlerHelper));
        this.handlers.add((Handler)new UnlockHandler(resourceHandlerHelper, responseHandler));
    }

    public List<CustomPostHandler> getCustomPostHandlers() {
        return this.customPostHandlers;
    }

    public void setCustomPostHandlers(List<CustomPostHandler> customPostHandlers) {
        this.customPostHandlers = customPostHandlers;
    }

    public Set<Handler> getHandlers() {
        return Collections.unmodifiableSet(this.handlers);
    }

    public Object getProperty(QName name, Resource r) {
        return this.propertyMap.getProperty(name, r);
    }

    public void setProperty(QName name, Object value, Resource r) {
        throw new UnsupportedOperationException("Not supported. Standard webdav properties are not writable");
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        PropertySource.PropertyMetaData propertyMetaData = this.propertyMap.getPropertyMetaData(name, r);
        if (propertyMetaData != null && this.userAgentHelper.isNautilus(HttpManager.request())) {
            String s;
            Object v = this.getProperty(name, r);
            if (v == null) {
                return PropertySource.PropertyMetaData.UNKNOWN;
            }
            if (v instanceof String && (s = (String)v).trim().length() == 0) {
                return PropertySource.PropertyMetaData.UNKNOWN;
            }
        }
        return propertyMetaData;
    }

    public void clearProperty(QName name, Resource r) {
        throw new UnsupportedOperationException("Not supported. Standard webdav properties are not writable");
    }

    public List<QName> getAllPropertyNames(Resource r) {
        return this.propertyMap.getAllPropertyNames(r);
    }

    static class SupportedLockPropertyWriter
    implements PropertyMap.StandardProperty<SupportedLocks> {
        SupportedLockPropertyWriter() {
        }

        public SupportedLocks getValue(PropFindableResource res) {
            if (res instanceof LockableResource) {
                return new SupportedLocks(res);
            }
            return null;
        }

        public String fieldName() {
            return "supportedlock";
        }

        public Class getValueClass() {
            return SupportedLocks.class;
        }
    }

    static class LockDiscoveryPropertyWriter
    implements PropertyMap.StandardProperty<LockToken> {
        LockDiscoveryPropertyWriter() {
        }

        public LockToken getValue(PropFindableResource res) {
            if (!(res instanceof LockableResource)) {
                return null;
            }
            LockableResource lr = (LockableResource)res;
            return lr.getCurrentLock();
        }

        public String fieldName() {
            return "lockdiscovery";
        }

        public Class getValueClass() {
            return LockToken.class;
        }
    }
}

