/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav2;

import io.milton.http.ExistingEntityHandler;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceHandler;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.PreConditionFailedException;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.LockableResource;
import io.milton.resource.Resource;
import io.milton.webdav.utils.LockUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockHandler
implements ExistingEntityHandler {
    private final Logger log = LoggerFactory.getLogger(UnlockHandler.class);
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final WebDavResponseHandler responseHandler;

    public UnlockHandler(ResourceHandlerHelper resourceHandlerHelper, WebDavResponseHandler responseHandler) {
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.responseHandler = responseHandler;
    }

    public void process(HttpManager httpManager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandlerHelper.process(httpManager, request, response, (ResourceHandler)this);
    }

    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.resourceHandlerHelper.processResource(manager, request, response, r, (ExistingEntityHandler)this);
    }

    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        LockableResource r = (LockableResource)resource;
        String sToken = request.getLockTokenHeader();
        sToken = LockUtils.parse((String)sToken);
        this.log.debug("unlocking token: " + sToken);
        try {
            r.unlock(sToken);
            this.responseHandler.respondNoContent(resource, response, request);
        }
        catch (PreConditionFailedException ex) {
            this.responseHandler.respondPreconditionFailed(request, response, resource);
        }
    }

    public String[] getMethods() {
        return new String[]{Request.Method.UNLOCK.code};
    }

    public boolean isCompatible(Resource handler) {
        return handler instanceof LockableResource;
    }
}

