/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav2;

import io.milton.common.Path;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpManager;
import io.milton.http.LockInfo;
import io.milton.http.LockInfoSaxHandler;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Request;
import io.milton.http.ResourceHandler;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.LockedException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.PreConditionFailedException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.LockableResource;
import io.milton.resource.LockingCollectionResource;
import io.milton.resource.Resource;
import io.milton.webdav.utils.LockUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class LockHandler
implements ResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(LockHandler.class);
    private final WebDavResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;

    public LockHandler(WebDavResponseHandler responseHandler, HandlerHelper handlerHelper) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
        LockUtils.init();
    }

    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] getMethods() {
        return new String[]{Request.Method.LOCK.code};
    }

    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, BadRequestException {
        if (!this.handlerHelper.checkExpects((Http11ResponseHandler)this.responseHandler, request, response)) {
            return;
        }
        String host = request.getHostHeader();
        String url = HttpManager.decodeUrl((String)request.getAbsolutePath());
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r != null) {
            log.debug("locking existing resource: {}", (Object)r.getName());
            this.processExistingResource(manager, request, response, r);
        } else {
            log.debug("lock target doesnt exist, attempting lock null..");
            this.processNonExistingResource(manager, request, response, host, url);
        }
    }

    protected void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException {
        if (this.handlerHelper.isNotCompatible(resource, request.getMethod()) || !this.isCompatible(resource)) {
            this.responseHandler.respondMethodNotImplemented(resource, response, request);
            return;
        }
        if (!this.handlerHelper.checkAuthorisation(manager, resource, request)) {
            this.responseHandler.respondUnauthorised(resource, response, request);
            return;
        }
        this.handlerHelper.checkExpects((Http11ResponseHandler)this.responseHandler, request, response);
        LockableResource r = (LockableResource)resource;
        LockTimeout timeout = LockTimeout.parseTimeout((Request)request);
        String ifHeader = request.getIfHeader();
        response.setContentTypeHeader("text/xml; charset=UTF-8");
        if (ifHeader == null || ifHeader.length() == 0) {
            this.processNewLock(manager, request, response, r, timeout);
        } else {
            this.processRefresh(manager, request, response, r, timeout, ifHeader);
        }
    }

    private void processNonExistingResource(HttpManager manager, Request request, Response response, String host, String url) throws NotAuthorizedException, BadRequestException {
        Path parentPath = Path.path((String)url);
        String name = parentPath.getName();
        parentPath = parentPath.getParent();
        url = parentPath.toString();
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r != null) {
            if (!this.handlerHelper.checkAuthorisation(manager, r, request)) {
                this.responseHandler.respondUnauthorised(r, response, request);
                return;
            }
            this.processCreateAndLock(manager, request, response, r, name);
        } else {
            log.debug("couldnt find parent to execute lock-null, returning not found");
            response.setStatus(Response.Status.SC_CONFLICT);
        }
    }

    private void processCreateAndLock(HttpManager manager, Request request, Response response, Resource parentResource, String name) throws NotAuthorizedException {
        if (parentResource instanceof LockingCollectionResource) {
            LockInfo lockInfo;
            log.debug("parent supports lock-null. doing createAndLock");
            LockingCollectionResource lockingParent = (LockingCollectionResource)parentResource;
            LockTimeout timeout = LockTimeout.parseTimeout((Request)request);
            response.setContentTypeHeader("text/xml; charset=UTF-8");
            try {
                lockInfo = LockInfoSaxHandler.parseLockInfo((Request)request);
            }
            catch (IOException | SAXException ex) {
                throw new RuntimeException("Exception reading request body", ex);
            }
            log.debug("Creating lock on unmapped resource: " + name);
            LockToken tok = lockingParent.createAndLock(name, timeout, lockInfo);
            if (tok == null) {
                throw new RuntimeException("createAndLock returned null, from resource of type: " + lockingParent.getClass().getCanonicalName());
            }
            response.setStatus(Response.Status.SC_CREATED);
            response.setLockTokenHeader("<opaquelocktoken:" + tok.tokenId + ">");
            LockUtils.respondLocked((LockToken)tok, (Request)request, (Response)response);
        } else {
            log.debug("parent does not support lock-null, respondong method not allowed");
            this.responseHandler.respondMethodNotImplemented(parentResource, response, request);
        }
    }

    public boolean isCompatible(Resource handler) {
        return handler instanceof LockableResource;
    }

    protected void processNewLock(HttpManager milton, Request request, Response response, LockableResource r, LockTimeout timeout) throws NotAuthorizedException {
        LockResult result;
        LockInfo lockInfo;
        try {
            lockInfo = LockInfoSaxHandler.parseLockInfo((Request)request);
        }
        catch (IOException | SAXException ex) {
            throw new RuntimeException("Exception reading request body", ex);
        }
        if (this.handlerHelper.isLockedOut(request, (Resource)r)) {
            this.responseHandler.respondLocked(request, response, (Resource)r);
            return;
        }
        log.debug("locking: {}", (Object)r.getName());
        try {
            result = r.lock(timeout, lockInfo);
        }
        catch (PreConditionFailedException ex) {
            this.responseHandler.respondPreconditionFailed(request, response, (Resource)r);
            return;
        }
        catch (LockedException ex) {
            this.responseHandler.respondLocked(request, response, (Resource)r);
            return;
        }
        if (result.isSuccessful()) {
            LockToken tok = result.getLockToken();
            log.debug("..locked ok: {}", (Object)tok.tokenId);
            response.setLockTokenHeader("<opaquelocktoken:" + tok.tokenId + ">");
            LockUtils.respondLocked((LockToken)tok, (Request)request, (Response)response);
        } else {
            LockUtils.respondLockFailure((LockResult)result, (Request)request, (Response)response);
        }
    }

    protected void processRefresh(HttpManager milton, Request request, Response response, LockableResource r, LockTimeout timeout, String ifHeader) throws NotAuthorizedException {
        LockResult result;
        String token = LockUtils.parse((String)ifHeader);
        log.debug("refreshing lock: {}", (Object)token);
        try {
            result = r.refreshLock(token, timeout);
        }
        catch (PreConditionFailedException ex) {
            this.responseHandler.respondPreconditionFailed(request, response, (Resource)r);
            return;
        }
        if (result == null) {
            throw new NullPointerException("Null lock result returned from: " + r.getClass());
        }
        if (result.isSuccessful()) {
            LockToken tok = result.getLockToken();
            response.setLockTokenHeader("<opaquelocktoken:" + tok.tokenId + ">");
            LockUtils.respondLocked((LockToken)tok, (Request)request, (Response)response);
        } else {
            LockUtils.respondLockFailure((LockResult)result, (Request)request, (Response)response);
        }
    }
}

