/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.report;

import io.milton.common.Utils;
import io.milton.http.HttpManager;
import io.milton.http.Response;
import io.milton.http.XmlWriter;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.report.Report;
import io.milton.http.report.ReportUtils;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropFindXmlFooter;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropertiesRequest;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.resource.PropFindableResource;
import io.milton.resource.RemovedResource;
import io.milton.resource.Resource;
import io.milton.resource.SyncCollectionResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SyncCollectionReport
implements Report {
    protected final Namespace NS_DAV = Namespace.getNamespace((String)WebDavProtocol.NS_DAV.getPrefix(), (String)WebDavProtocol.NS_DAV.getName());
    private final PropFindPropertyBuilder propertyBuilder;
    private final PropFindXmlGenerator xmlGenerator;

    public SyncCollectionReport(PropFindPropertyBuilder propertyBuilder, PropFindXmlGenerator xmlGenerator) {
        this.propertyBuilder = propertyBuilder;
        this.xmlGenerator = xmlGenerator;
    }

    public String getName() {
        return "sync-collection";
    }

    public String process(String host, String path, Resource r, Document doc) throws BadRequestException, NotAuthorizedException {
        String syncTokenText;
        Element syncLevelElm;
        if (!(r instanceof SyncCollectionResource)) {
            throw new BadRequestException(r, "This resource does not support sync-token.");
        }
        SyncCollectionResource syncCollectionResource = (SyncCollectionResource)r;
        if (HttpManager.request().getDepthHeader() != 0) {
            // empty if block
        }
        if ((syncLevelElm = ReportUtils.find((Element)doc.getRootElement(), (String)"sync-level", (Namespace)this.NS_DAV)) == null) {
            throw new BadRequestException(r, "DAV:sync-level must be included in the request.");
        }
        String syncLevel = syncLevelElm.getText();
        SyncLevel lv = SyncLevel.One;
        if ("1".equals(syncLevel)) {
            lv = SyncLevel.One;
        } else if ("infinite".equals(syncLevel)) {
            lv = SyncLevel.Infinite;
        } else {
            throw new BadRequestException(r, String.format("Unsupported DAV:sync-level: \"%s\", must be either \"1\" or \"infinite\".", syncLevel));
        }
        URI syncToken = null;
        Element syncTokenElm = ReportUtils.find((Element)doc.getRootElement(), (String)"sync-token", (Namespace)this.NS_DAV);
        if (syncTokenElm != null && (syncTokenText = syncTokenElm.getText()) != null && !syncTokenText.isEmpty()) {
            try {
                syncToken = new URI(syncTokenText);
            }
            catch (URISyntaxException e) {
                throw new BadRequestException(r, "sync-token must be a valid URI.");
            }
        }
        String parentHref = HttpManager.request().getAbsolutePath();
        parentHref = Utils.suffixSlash((String)parentHref);
        ArrayList<PropFindResponse> respProps = new ArrayList<PropFindResponse>();
        this.findResources(syncCollectionResource, doc, syncToken, lv, parentHref, respProps);
        final URI nextSyncToken = syncCollectionResource.getSyncToken();
        return this.xmlGenerator.generate(respProps, new PropFindXmlFooter(){

            public void footer(XmlWriter writer) {
                writer.writeProperty(WebDavProtocol.NS_DAV.getPrefix(), "sync-token", nextSyncToken.toString());
            }
        });
    }

    private void findResources(SyncCollectionResource parent, Document doc, URI syncToken, SyncLevel syncLevel, String parentHref, List<PropFindResponse> respProps) throws NotAuthorizedException, BadRequestException {
        Map children = parent.findResourcesBySyncToken(syncToken);
        for (String href : children.keySet()) {
            Resource r = (Resource)children.get(href);
            if (r instanceof RemovedResource) {
                if (syncToken != null) {
                    PropFindResponse resp = new PropFindResponse(href, Response.Status.SC_NOT_FOUND);
                    respProps.add(resp);
                }
            } else if (r instanceof PropFindableResource) {
                Set<QName> props = this.getProps(doc);
                PropertiesRequest parseResult = PropertiesRequest.toProperties(props);
                PropFindableResource pfr = (PropFindableResource)r;
                try {
                    respProps.addAll(this.propertyBuilder.buildProperties(pfr, 0, parseResult, href));
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException("There was an unencoded url requested: " + href, ex);
                }
            }
            if (syncLevel != SyncLevel.Infinite || !(r instanceof SyncCollectionResource)) continue;
            String currentHref = Utils.suffixSlash((String)(parentHref + r.getName()));
            this.findResources((SyncCollectionResource)r, doc, syncToken, syncLevel, currentHref, respProps);
        }
    }

    private Set<QName> getProps(Document doc) {
        Element elProp = doc.getRootElement().getChild("prop", this.NS_DAV);
        if (elProp == null) {
            throw new RuntimeException("No prop element");
        }
        HashSet<QName> set = new HashSet<QName>();
        for (Object o : elProp.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            String local = el.getName();
            String ns = el.getNamespaceURI();
            set.add(new QName(ns, local, el.getNamespacePrefix()));
        }
        return set;
    }

    private static enum SyncLevel {
        One,
        Infinite;

    }
}

