/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.report;

import io.milton.common.Utils;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.report.QualifiedReport;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropertiesRequest;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultiGetReport
implements QualifiedReport {
    private static final Logger log = LoggerFactory.getLogger(AbstractMultiGetReport.class);
    protected final ResourceFactory resourceFactory;
    protected final PropFindPropertyBuilder propertyBuilder;
    protected final PropFindXmlGenerator xmlGenerator;
    protected final Namespace NS_DAV = Namespace.getNamespace((String)WebDavProtocol.NS_DAV.getPrefix(), (String)WebDavProtocol.NS_DAV.getName());

    public AbstractMultiGetReport(ResourceFactory resourceFactory, PropFindPropertyBuilder propertyBuilder, PropFindXmlGenerator xmlGenerator) {
        if (resourceFactory == null) {
            throw new NullPointerException("resourceFactory is null");
        }
        this.resourceFactory = resourceFactory;
        this.propertyBuilder = propertyBuilder;
        this.xmlGenerator = xmlGenerator;
    }

    public String process(String host, String path, Resource calendar, Document doc) throws NotAuthorizedException, BadRequestException {
        log.debug("process report: " + this.getName());
        Set<QName> props = this.getProps(doc);
        List<String> hrefs = this.getHrefs(doc);
        PropertiesRequest parseResult = PropertiesRequest.toProperties(props);
        ArrayList respProps = new ArrayList();
        for (String href : hrefs) {
            String decodedHref;
            Resource r;
            if (!href.startsWith("/")) {
                href = Utils.suffixSlash((String)path) + href;
            }
            if ((r = this.resourceFactory.getResource(host, decodedHref = HttpManager.decodeUrl((String)href))) != null) {
                if (r instanceof PropFindableResource) {
                    PropFindableResource pfr = (PropFindableResource)r;
                    try {
                        respProps.addAll(this.propertyBuilder.buildProperties(pfr, 0, parseResult, href));
                        continue;
                    }
                    catch (URISyntaxException ex) {
                        throw new RuntimeException("There was an unencoded url requested: " + href, ex);
                    }
                }
                log.warn("requested href is for a non PropFindableResource: " + r.getClass() + " - " + href);
                continue;
            }
            log.warn("requested href not found: " + href + " on resource factory: " + this.resourceFactory.getClass());
        }
        String xml = this.xmlGenerator.generate(respProps);
        if (log.isTraceEnabled()) {
            log.trace(this.getName() + ": response");
            log.trace(xml);
        }
        return xml;
    }

    private List<String> getHrefs(Document doc) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : doc.getRootElement().getChildren()) {
            Element el;
            if (!(o instanceof Element) || !(el = (Element)o).getName().equals("href")) continue;
            String href = el.getText();
            list.add(href);
            if (!log.isTraceEnabled()) continue;
            log.trace(" href: " + href);
        }
        return list;
    }

    private Set<QName> getProps(Document doc) {
        Element elProp = doc.getRootElement().getChild("prop", this.NS_DAV);
        if (elProp == null) {
            throw new RuntimeException("No prop element");
        }
        HashSet<QName> set = new HashSet<QName>();
        for (Object o : elProp.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            String local = el.getName();
            String ns = el.getNamespaceURI();
            set.add(new QName(ns, local, el.getNamespacePrefix()));
        }
        return set;
    }
}

