/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.carddav;

import io.milton.common.LogUtils;
import io.milton.http.Auth;
import io.milton.http.Handler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpExtension;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.WellKnownResourceFactory;
import io.milton.http.caldav.ExpandPropertyReport;
import io.milton.http.carddav.AddressBookMultiGetReport;
import io.milton.http.carddav.AddressBookQueryReport;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.CustomPostHandler;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.http.report.Report;
import io.milton.http.values.AddressDataTypeList;
import io.milton.http.values.HrefList;
import io.milton.http.values.Pair;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropertyMap;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.principal.CardDavPrincipal;
import io.milton.principal.DirectoryGatewayCardDavPrincipal;
import io.milton.property.PropertySource;
import io.milton.resource.AddressBookResource;
import io.milton.resource.AddressResource;
import io.milton.resource.DigestResource;
import io.milton.resource.GetableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardDavProtocol
implements HttpExtension,
PropertySource,
WellKnownResourceFactory.WellKnownHandler {
    private static final Logger log = LoggerFactory.getLogger(CardDavProtocol.class);
    public static final String CARDDAV_NS = "urn:ietf:params:xml:ns:carddav";
    private final Set<Handler> handlers;
    private final PropertyMap propertyMapCardDav = new PropertyMap("urn:ietf:params:xml:ns:carddav");

    public CardDavProtocol(ResourceFactory resourceFactory, WebDavResponseHandler responseHandler, HandlerHelper handlerHelper, WebDavProtocol webDavProtocol, PropFindXmlGenerator gen, PropFindPropertyBuilder propertyBuilder) {
        this.propertyMapCardDav.add((PropertyMap.StandardProperty)new AddressBookHomeSetProperty());
        this.propertyMapCardDav.add((PropertyMap.StandardProperty)new AddressBookDescriptionProperty());
        this.propertyMapCardDav.add((PropertyMap.StandardProperty)new SupportedAddressData());
        this.propertyMapCardDav.add((PropertyMap.StandardProperty)new PrincipalAddress());
        this.propertyMapCardDav.add((PropertyMap.StandardProperty)new DirectoryGateway());
        this.propertyMapCardDav.add((PropertyMap.StandardProperty)new AddressDataProperty());
        this.handlers = new HashSet<Handler>();
        webDavProtocol.addPropertySource((PropertySource)this);
        webDavProtocol.addReport((Report)new AddressBookMultiGetReport(resourceFactory, propertyBuilder, gen));
        webDavProtocol.addReport((Report)new AddressBookQueryReport(resourceFactory, propertyBuilder, gen));
        webDavProtocol.addReport((Report)new ExpandPropertyReport(resourceFactory, propertyBuilder, gen));
    }

    public Set<Handler> getHandlers() {
        return Collections.unmodifiableSet(this.handlers);
    }

    public Object getProperty(QName name, Resource r) {
        log.trace("getProperty: {}", (Object)name.getLocalPart());
        Object o = this.propertyMapCardDav.hasProperty(name) ? this.propertyMapCardDav.getProperty(name, r) : null;
        log.debug("result : " + o);
        return o;
    }

    public void setProperty(QName name, Object value, Resource r) {
        log.trace("setProperty: {}", (Object)name.getLocalPart());
        if (this.propertyMapCardDav.hasProperty(name)) {
            this.propertyMapCardDav.setProperty(name, r, value);
        }
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        PropertySource.PropertyMetaData md = this.propertyMapCardDav.hasProperty(name) ? this.propertyMapCardDav.getPropertyMetaData(name, r) : null;
        log.trace("getPropertyMetaData: {} - returned: {}", (Object)name.getLocalPart(), (Object)md);
        return md;
    }

    public void clearProperty(QName name, Resource r) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<QName> getAllPropertyNames(Resource r) {
        log.trace("getAllPropertyNames");
        ArrayList<QName> list = new ArrayList<QName>(this.propertyMapCardDav.getAllPropertyNames(r));
        return list;
    }

    public List<CustomPostHandler> getCustomPostHandlers() {
        return null;
    }

    public String getWellKnownName() {
        return "carddav";
    }

    public Resource locateWellKnownResource(Resource host) {
        log.trace("found a carddav well-known resource");
        return new CardDavWellKnownResource(host);
    }

    public class CardDavWellKnownResource
    implements DigestResource,
    GetableResource,
    PropFindableResource {
        private final Resource host;

        public CardDavWellKnownResource(Resource host) {
            this.host = host;
        }

        public String getUniqueId() {
            return null;
        }

        public String getName() {
            return CardDavProtocol.this.getWellKnownName();
        }

        public Object authenticate(String user, String password) {
            return this.host.authenticate(user, password);
        }

        public boolean authorise(Request request, Request.Method method, Auth auth) {
            return auth != null;
        }

        public String getRealm() {
            return this.host.getRealm();
        }

        public Date getModifiedDate() {
            return null;
        }

        public String checkRedirect(Request request) {
            log.trace("well-known: checkRedirect");
            Auth auth = request.getAuthorization();
            if (auth != null && auth.getTag() != null) {
                if (auth.getTag() instanceof CardDavPrincipal) {
                    CardDavPrincipal p = (CardDavPrincipal)auth.getTag();
                    HrefList addressBookHomes = p.getAddressBookHomeSet();
                    if (addressBookHomes == null || addressBookHomes.isEmpty()) {
                        log.error("can't redirect, CalDavPrincipal.getCalendatHomeSet did not return an address. Check implementation class: " + p.getClass());
                        return null;
                    }
                    String first = (String)addressBookHomes.get(0);
                    LogUtils.debug((Logger)log, (Object[])new Object[]{"well-known: checkRedirect. redirecting to:", first});
                    return first;
                }
                log.warn("can't redirect, auth.getTag is not a CardDavPrincipal, is a: " + auth.getTag().getClass() + " To use CARDDAV, the user object returned from authenticate must be a " + CardDavPrincipal.class);
                return null;
            }
            log.trace("can't redirect, no authorisation");
            return null;
        }

        public Object authenticate(DigestResponse digestRequest) {
            if (this.host instanceof DigestResource) {
                DigestResource dr = (DigestResource)this.host;
                return dr.authenticate(digestRequest);
            }
            return null;
        }

        public boolean isDigestAllowed() {
            if (this.host instanceof DigestResource) {
                DigestResource dr = (DigestResource)this.host;
                return dr.isDigestAllowed();
            }
            return false;
        }

        public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Long getMaxAgeSeconds(Auth auth) {
            return null;
        }

        public String getContentType(String accepts) {
            return null;
        }

        public Long getContentLength() {
            return null;
        }

        public Date getCreateDate() {
            return null;
        }
    }

    static class DirectoryGateway
    implements PropertyMap.StandardProperty<HrefList> {
        DirectoryGateway() {
        }

        public String fieldName() {
            return "directory-gateway";
        }

        public HrefList getValue(PropFindableResource res) {
            if (res instanceof DirectoryGatewayCardDavPrincipal) {
                return ((DirectoryGatewayCardDavPrincipal)res).getDirectoryGateway();
            }
            return null;
        }

        public Class<HrefList> getValueClass() {
            return HrefList.class;
        }
    }

    static class PrincipalAddress
    implements PropertyMap.StandardProperty<String> {
        PrincipalAddress() {
        }

        public String fieldName() {
            return "principal-address";
        }

        public String getValue(PropFindableResource res) {
            if (res instanceof CardDavPrincipal) {
                return ((CardDavPrincipal)res).getAddress();
            }
            return null;
        }

        public Class<Long> getValueClass() {
            return Long.class;
        }
    }

    static class MaxResourceSize
    implements PropertyMap.StandardProperty<Long> {
        MaxResourceSize() {
        }

        public String fieldName() {
            return "max-resource-size";
        }

        public Long getValue(PropFindableResource res) {
            if (res instanceof AddressBookResource) {
                return ((AddressBookResource)res).getMaxResourceSize();
            }
            return null;
        }

        public Class<Long> getValueClass() {
            return Long.class;
        }
    }

    static class SupportedAddressData
    implements PropertyMap.StandardProperty<List<Pair<String, String>>> {
        SupportedAddressData() {
        }

        public String fieldName() {
            return "supported-address-data";
        }

        public List<Pair<String, String>> getValue(PropFindableResource res) {
            if (res instanceof AddressBookResource) {
                return ((AddressBookResource)res).getSupportedAddressData();
            }
            return null;
        }

        public Class<AddressDataTypeList> getValueClass() {
            return AddressDataTypeList.class;
        }
    }

    static class AddressBookDescriptionProperty
    implements PropertyMap.StandardProperty<String> {
        AddressBookDescriptionProperty() {
        }

        public String fieldName() {
            return "addressbook-description";
        }

        public String getValue(PropFindableResource res) {
            if (res instanceof AddressBookResource) {
                AddressBookResource addressBookResource = (AddressBookResource)res;
                return addressBookResource.getDescription().getValue();
            }
            return null;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }

    static class AddressBookHomeSetProperty
    implements PropertyMap.StandardProperty<HrefList> {
        AddressBookHomeSetProperty() {
        }

        public String fieldName() {
            return "addressbook-home-set";
        }

        public HrefList getValue(PropFindableResource res) {
            if (res instanceof CardDavPrincipal) {
                return ((CardDavPrincipal)res).getAddressBookHomeSet();
            }
            return null;
        }

        public Class<HrefList> getValueClass() {
            return HrefList.class;
        }
    }

    static class AddressDataProperty
    implements PropertyMap.StandardProperty<String> {
        AddressDataProperty() {
        }

        public String fieldName() {
            return "address-data";
        }

        public String getValue(PropFindableResource res) {
            if (res instanceof AddressResource) {
                AddressResource resource = (AddressResource)res;
                return resource.getAddressData();
            }
            return null;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
}

