/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.carddav;

import io.milton.http.webdav.ResourceTypeHelper;
import io.milton.resource.AddressBookDirectoryResource;
import io.milton.resource.AddressBookResource;
import io.milton.resource.Resource;
import io.milton.webdav.utils.LockUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressBookResourceTypeHelper
implements ResourceTypeHelper {
    private static final Logger log = LoggerFactory.getLogger(AddressBookResourceTypeHelper.class);
    private final ResourceTypeHelper wrapped;

    public AddressBookResourceTypeHelper(ResourceTypeHelper wrapped) {
        log.debug("CalendarResourceTypeHelper constructed :" + wrapped.getClass().getSimpleName());
        this.wrapped = wrapped;
    }

    public List<QName> getResourceTypes(Resource r) {
        if (log.isTraceEnabled()) {
            log.trace("getResourceTypes:" + r.getClass().getCanonicalName());
        }
        ArrayList<QName> list = this.wrapped.getResourceTypes(r);
        if (r instanceof AddressBookResource) {
            log.trace("getResourceTypes: is a AddressBookResource");
            QName qn = new QName("urn:ietf:params:xml:ns:carddav", "addressbook");
            QName qn2 = new QName("urn:ietf:params:xml:ns:carddav", "directory");
            if (list == null) {
                list = new ArrayList<QName>();
            }
            if (r instanceof AddressBookDirectoryResource) {
                list.add(qn2);
            }
            list.add(qn);
        }
        return list;
    }

    public List<String> getSupportedLevels(Resource r) {
        log.debug("getSupportedLevels");
        List list = this.wrapped.getSupportedLevels(r);
        LockUtils.add((List)list, (String)"3");
        LockUtils.add((List)list, (String)"addressbook");
        LockUtils.add((List)list, (String)"extended-mkcol");
        return list;
    }
}

