/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.carddav;

import io.milton.http.ResourceFactory;
import io.milton.http.carddav.AddressBookMultiGetReport;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.report.QualifiedReport;
import io.milton.http.report.ReportUtils;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropertiesRequest;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.principal.PrincipalSearchCriteria;
import io.milton.resource.AddressBookQuerySearchableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressBookQueryReport
implements QualifiedReport {
    private static final Logger log = LoggerFactory.getLogger(AddressBookMultiGetReport.class);
    private final Namespace NS_DAV = Namespace.getNamespace((String)WebDavProtocol.NS_DAV.getPrefix(), (String)WebDavProtocol.NS_DAV.getName());
    private final Namespace CARDDAV_NS = Namespace.getNamespace((String)"C", (String)"urn:ietf:params:xml:ns:carddav");
    private final ResourceFactory resourceFactory;
    private final PropFindPropertyBuilder propertyBuilder;
    private final PropFindXmlGenerator xmlGenerator;

    public AddressBookQueryReport(ResourceFactory resourceFactory, PropFindPropertyBuilder propertyBuilder, PropFindXmlGenerator xmlGenerator) {
        this.resourceFactory = resourceFactory;
        this.propertyBuilder = propertyBuilder;
        this.xmlGenerator = xmlGenerator;
    }

    public String getName() {
        return "addressbook-query";
    }

    public QName getQualifiedName() {
        return new QName(this.CARDDAV_NS.getURI(), this.getName());
    }

    public String process(String host, String path, Resource res, Document doc) {
        log.trace("AddressBookQueryReport.process() host=" + host + " path=" + path);
        Set<QName> props = this.getProps(doc);
        PropertiesRequest parseResult = PropertiesRequest.toProperties(props);
        PrincipalSearchCriteria crit = new PrincipalSearchCriteria();
        List filters = ReportUtils.findAll((Element)doc.getRootElement(), (String)"filter", (Namespace)this.CARDDAV_NS);
        if (filters.size() >= 1) {
            String filterMatchType;
            crit.setTest(PrincipalSearchCriteria.TestType.ANY);
            Attribute attribute = ((Element)filters.get(0)).getAttribute("test");
            if (attribute != null && "allof".equalsIgnoreCase(filterMatchType = attribute.getValue())) {
                crit.setTest(PrincipalSearchCriteria.TestType.ALL);
            }
        }
        ArrayList<PrincipalSearchCriteria.SearchItem> searchTerms = new ArrayList<PrincipalSearchCriteria.SearchItem>();
        List propFilters = ReportUtils.findAll((Element)doc.getRootElement(), (String)"prop-filter", (Namespace)this.CARDDAV_NS);
        for (Element propFilter : propFilters) {
            String propFilterName = propFilter.getAttribute("name").getValue();
            List textMatchs = ReportUtils.findAll((Element)propFilter, (String)"text-match", (Namespace)this.CARDDAV_NS);
            for (Element textMath : textMatchs) {
                String textMatchType = textMath.getAttribute("match-type").getValue();
                String matchVal = textMath.getText();
                PrincipalSearchCriteria.SearchItem item = new PrincipalSearchCriteria.SearchItem();
                item.setField(propFilterName);
                item.setMatchType(PrincipalSearchCriteria.MatchType.fromCode((String)textMatchType));
                item.setValue(matchVal);
                searchTerms.add(item);
            }
        }
        crit.setSearchItems(searchTerms);
        try {
            Resource resource = this.resourceFactory.getResource(host, path);
            if (resource instanceof AddressBookQuerySearchableResource) {
                log.debug("resource is AddressBookQuerySearchableResource");
                AddressBookQuerySearchableResource searchableAddressBook = (AddressBookQuerySearchableResource)resource;
                List result = searchableAddressBook.getChildren(crit);
                ArrayList respProps = new ArrayList();
                for (Resource r : result) {
                    if (r == null || !(r instanceof PropFindableResource)) continue;
                    PropFindableResource pfr = (PropFindableResource)r;
                    try {
                        respProps.addAll(this.propertyBuilder.buildProperties(pfr, 0, parseResult, path + r.getUniqueId()));
                    }
                    catch (URISyntaxException ex) {
                        throw new RuntimeException("There was an unencoded url requested: " + path + r.getUniqueId(), ex);
                    }
                }
                String xml = this.xmlGenerator.generate(respProps);
                log.trace("AddressBookQueryReport result:\n" + xml);
                return xml;
            }
            log.warn("You must implement AddressBookQuerySearchableResource to support CardDAV addressbook-query");
        }
        catch (BadRequestException | NotAuthorizedException e) {
            log.error("ERROR occured in AddressBookQueryReport.process", e);
        }
        return "";
    }

    private Set<QName> getProps(Document doc) {
        Element elProp = doc.getRootElement().getChild("prop", this.NS_DAV);
        if (elProp == null) {
            throw new RuntimeException("No prop element");
        }
        HashSet<QName> set = new HashSet<QName>();
        for (Object o : elProp.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            String local = el.getName();
            String ns = el.getNamespaceURI();
            set.add(new QName(ns, local, el.getNamespacePrefix()));
        }
        return set;
    }
}

