/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.caldav;

import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.annotated.scheduling.SchedulingOutboxResource;
import io.milton.http.annotated.scheduling.SchedulingXmlHelper;
import io.milton.http.entity.StringEntity;
import io.milton.http.http11.CustomPostHandler;
import io.milton.resource.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingCustomPostHandler
implements CustomPostHandler {
    private static final Logger log = LoggerFactory.getLogger(SchedulingCustomPostHandler.class);
    private final SchedulingXmlHelper schedulingHelper = new SchedulingXmlHelper();

    public boolean supports(Resource resource, Request request) {
        boolean b = resource instanceof SchedulingOutboxResource && this.contentTypeIsCalendar(request);
        log.trace("supports: " + b);
        return b;
    }

    public void process(Resource resource, Request request, Response response) {
        log.trace("process");
        try {
            SchedulingOutboxResource outbox = (SchedulingOutboxResource)resource;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)bout);
            String iCalText = bout.toString("UTF-8");
            log.trace(iCalText);
            System.out.println("Freebusy query: " + iCalText);
            List respItems = outbox.queryFreeBusy(iCalText);
            String xml = this.schedulingHelper.generateXml(respItems);
            response.setStatus(Response.Status.SC_OK);
            response.setDateHeader(new Date());
            response.setContentTypeHeader("application/xml; charset=\"utf-8\"");
            response.setContentLengthHeader(Long.valueOf(xml.length()));
            response.setEntity((Response.Entity)new StringEntity(xml));
            System.out.println("FreeBusy response= " + xml);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean contentTypeIsCalendar(Request r) {
        String s = r.getContentTypeHeader();
        return "text/calendar".equals(s);
    }
}

