/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.caldav;

import io.milton.http.Handler;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.webdav.MkColHandler;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropPatchHandler;
import io.milton.http.webdav.PropPatchParseResult;
import io.milton.http.webdav.PropPatchSetter;
import io.milton.resource.CollectionResource;
import io.milton.resource.ExtMakeCalendarResource;
import io.milton.resource.MakeCalendarResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkCalendarHandler
implements Handler,
MkColHandler.CollectionResourceCreator {
    private static final Logger log = LoggerFactory.getLogger(MkCalendarHandler.class);
    private final MkColHandler mkColHandler;
    private final PropPatchHandler propPatchHandler;

    public MkCalendarHandler(MkColHandler mkColHandler, PropPatchHandler propPatchHandler) {
        this.mkColHandler = mkColHandler;
        this.propPatchHandler = propPatchHandler;
    }

    public String[] getMethods() {
        return new String[]{Request.Method.MKCALENDAR.code};
    }

    public boolean isCompatible(Resource handler) {
        return handler instanceof MakeCalendarResource;
    }

    public void process(HttpManager manager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        log.info("process");
        try {
            this.mkColHandler.process(manager, request, response, (MkColHandler.CollectionResourceCreator)this);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public CollectionResource createResource(MakeCollectionableResource existingCol, String newName, Request request) throws ConflictException, NotAuthorizedException, BadRequestException, IOException {
        log.info("createResource");
        if (existingCol instanceof ExtMakeCalendarResource) {
            final ExtMakeCalendarResource col = (ExtMakeCalendarResource)existingCol;
            final ArrayList theNewCol = new ArrayList();
            PropFindResponse resp = this.propPatchHandler.doPropPatch(request, (Resource)col, new PropPatchSetter(){

                public PropFindResponse setProperties(String href, PropPatchParseResult parseResult, Resource r) throws NotAuthorizedException, BadRequestException, ConflictException {
                    CollectionResource newCal = col.createCalendar(href, parseResult.getFieldsToSet());
                    theNewCol.add(newCal);
                    return new PropFindResponse(href, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
                }

                public boolean supports(Resource r) {
                    return true;
                }
            });
            return (CollectionResource)theNewCol.get(0);
        }
        MakeCalendarResource mkcal = (MakeCalendarResource)existingCol;
        CollectionResource newCal = mkcal.createCalendar(newName);
        log.info("do proppatch on new calendar collection resource");
        this.propPatchHandler.doPropPatch(request, (Resource)newCal);
        return newCal;
    }
}

