/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.caldav;

import io.milton.http.caldav.EventResource;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.component.VEvent;

public class ICalFormatter {
    public static final String MAILTO = "mailto:";
    private static final String PATTERN_ICAL = "yyyyMMdd HHmmss";

    public void parseEvent(EventResource r, String data) throws IOException, ParserException {
        CalendarBuilder builder = new CalendarBuilder();
        Calendar calendar = builder.build((InputStream)new ByteArrayInputStream(data.getBytes("UTF-8")));
        if (calendar == null) {
            return;
        }
        VEvent ev = this.event(calendar);
        if (ev == null) {
            return;
        }
        String summary = null;
        if (ev.getSummary() != null) {
            summary = ev.getSummary().getValue();
        }
        r.setSummary(summary);
        r.setStart((java.util.Date)ev.getStartDate().getDate());
        Date endDate = null;
        if (ev.getEndDate() != null) {
            endDate = ev.getEndDate().getDate();
        }
        r.setEnd((java.util.Date)endDate);
    }

    public List<String> parseAttendees(String data) {
        String[] lines = this.toLines(data);
        ArrayList<String> attendees = new ArrayList<String>();
        for (String line : lines) {
            if (line == null || !line.contains(":")) continue;
            int pos = line.indexOf(":");
            String key = line.substring(0, pos);
            String val = line.substring(pos + 1);
            if (!key.contains("ATTENDEE")) continue;
            String s = this.getMailTo(val);
            attendees.add(s);
        }
        return attendees;
    }

    public FreeBusyRequest parseFreeBusyRequest(String data) {
        FreeBusyRequest r = new FreeBusyRequest();
        String[] lines = this.toLines(data);
        ArrayList<String> attendees = new ArrayList<String>();
        r.setAttendeeMailtos(attendees);
        for (String line : lines) {
            String s;
            java.util.Date dt;
            if (line == null || !line.contains(":")) continue;
            int pos = line.indexOf(":");
            String key = line.substring(0, pos);
            String val = line.substring(pos + 1);
            r.getLines().put(key, line);
            if (key.equals("DTSTART")) {
                dt = this.parseDate(val);
                r.setStart(dt);
                continue;
            }
            if (key.equals("DTEND")) {
                dt = this.parseDate(val);
                r.setFinish(dt);
                continue;
            }
            if (key.equals("ORGANIZER")) {
                s = this.getMailTo(val);
                System.out.println("org: " + s);
                r.setOrganiserMailto(s);
                continue;
            }
            if (!key.contains("ATTENDEE")) continue;
            System.out.println("found attendee");
            s = this.getMailTo(val);
            System.out.println("attendee: " + s);
            attendees.add(s);
            r.getAttendeeLines().put(s, line);
        }
        return r;
    }

    public String formatEvent(EventResource r) {
        return "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//MiltonCalDAV//EN\nBEGIN:VEVENT\nUID:" + r.getUniqueId() + "\nDTSTAMP:19970714T170000Z\nSUMMARY:" + r.getSummary() + "\nDTSTART:" + this.formatDate(r.getStart()) + "\nDTEND:" + this.formatDate(r.getEnd()) + "\nEND:VEVENT\nEND:VCALENDAR";
    }

    public java.util.Date parseDate(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        s = s.replace("T", " ");
        s = s.replace("Z", "");
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_ICAL);
        try {
            return sdf.parse(s);
        }
        catch (ParseException ex) {
            throw new RuntimeException(s, ex);
        }
    }

    public String formatDate(java.util.Date d) {
        if (d == null) {
            return "";
        }
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(d);
        return cal.get(1) + ICalFormatter.pad2(cal.get(2) + 1) + ICalFormatter.pad2(cal.get(5)) + 'T' + ICalFormatter.pad2(cal.get(11)) + ICalFormatter.pad2(cal.get(12)) + ICalFormatter.pad2(cal.get(13)) + 'Z';
    }

    private static String pad2(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return i + "";
    }

    private String getMailTo(String s) {
        int pos = s.lastIndexOf(MAILTO);
        if (pos >= 0) {
            return s.substring(pos + MAILTO.length(), s.length());
        }
        return null;
    }

    private String[] toLines(String data) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String s : data.split("\n")) {
            if (s.startsWith(" ")) {
                s = s.trim();
                String line = (String)lines.get(lines.size() - 1) + s;
                lines.remove(lines.size() - 1);
                lines.add(line);
                continue;
            }
            s = s.trim();
            lines.add(s);
        }
        String[] arr = new String[lines.size()];
        return lines.toArray(arr);
    }

    private VEvent event(Calendar cal) {
        return (VEvent)cal.getComponent("VEVENT");
    }

    public String buildFreeBusyAttendeeResponse(List<? extends EventResource> events, FreeBusyRequest request, String domain, String attendeeMailto) throws NotAuthorizedException, BadRequestException {
        Map<String, String> source = request.getLines();
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN:VCALENDAR\n");
        sb.append("VERSION:2.0\n");
        sb.append("PRODID:-//milton.io//CalDAV Server//EN\n");
        sb.append("METHOD:REPLY\n");
        sb.append("BEGIN:VFREEBUSY\n");
        sb.append(source.get("UID")).append("\n");
        sb.append(source.get("DTSTAMP")).append("\n");
        sb.append(source.get("DTSTART")).append("\n");
        sb.append(source.get("DTEND")).append("\n");
        sb.append(source.get("ORGANIZER")).append("\n");
        if (attendeeMailto == null) {
            throw new RuntimeException("attendeeMailto is null");
        }
        sb.append(request.getAttendeeLines().get(attendeeMailto)).append("\n");
        for (EventResource eventResource : events) {
            sb.append("FREEBUSY;FBTYPE=BUSY:");
            sb.append(this.formatDate(eventResource.getStart()));
            sb.append("/");
            sb.append(this.formatDate(eventResource.getEnd()));
            sb.append("\n");
        }
        sb.append("END:VFREEBUSY\n");
        sb.append("END:VCALENDAR\n");
        return sb.toString();
    }

    public static class FreeBusyRequest {
        private java.util.Date start;
        private java.util.Date finish;
        private String organiserMailto;
        private List<String> attendeeMailtos;
        private final Map<String, String> attendeeLines = new HashMap<String, String>();
        private final Map<String, String> lines = new HashMap<String, String>();

        public java.util.Date getStart() {
            return this.start;
        }

        public void setStart(java.util.Date start) {
            this.start = start;
        }

        public java.util.Date getFinish() {
            return this.finish;
        }

        public void setFinish(java.util.Date finish) {
            this.finish = finish;
        }

        public String getOrganiserMailto() {
            return this.organiserMailto;
        }

        public void setOrganiserMailto(String organiserMailto) {
            this.organiserMailto = organiserMailto;
        }

        public List<String> getAttendeeMailtos() {
            return this.attendeeMailtos;
        }

        public void setAttendeeMailtos(List<String> attendeeMailtos) {
            this.attendeeMailtos = attendeeMailtos;
        }

        public Map<String, String> getLines() {
            return this.lines;
        }

        public Map<String, String> getAttendeeLines() {
            return this.attendeeLines;
        }
    }
}

