/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.caldav;

import io.milton.http.ResourceFactory;
import io.milton.http.caldav.MultiGetReport;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.report.Report;
import io.milton.http.values.HrefList;
import io.milton.http.values.PropFindResponseList;
import io.milton.http.values.ValueAndType;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropertiesRequest;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandPropertyReport
implements Report {
    private static final Logger log = LoggerFactory.getLogger(MultiGetReport.class);
    private final ResourceFactory resourceFactory;
    private final PropFindPropertyBuilder propertyBuilder;
    private final PropFindXmlGenerator xmlGenerator;

    public ExpandPropertyReport(ResourceFactory resourceFactory, PropFindPropertyBuilder propertyBuilder, PropFindXmlGenerator xmlGenerator) {
        this.resourceFactory = resourceFactory;
        this.propertyBuilder = propertyBuilder;
        this.xmlGenerator = xmlGenerator;
    }

    public String process(String host, String path, Resource calendar, Document doc) throws NotAuthorizedException, BadRequestException {
        List propFindResponses;
        log.debug("process");
        PropertiesRequest parseResult = this.parse(doc.getRootElement());
        try {
            PropFindableResource pfr = (PropFindableResource)calendar;
            propFindResponses = this.propertyBuilder.buildProperties(pfr, 1, parseResult, path);
            for (PropFindResponse r : propFindResponses) {
                Set set = r.getKnownProperties().entrySet();
                set = new HashSet(set);
                for (Map.Entry p : set) {
                    Object val = ((ValueAndType)p.getValue()).getValue();
                    QName name = (QName)p.getKey();
                    if (!(val instanceof HrefList)) continue;
                    HrefList hrefList = (HrefList)val;
                    PropertiesRequest.Property prop = parseResult.get(name);
                    PropFindResponseList propFindResponseList = this.toResponseList(host, hrefList, prop);
                    this.replaceHrefs(host, propFindResponseList, prop);
                    r.getKnownProperties().remove(name);
                    r.getKnownProperties().put(name, new ValueAndType((Object)propFindResponseList, PropFindResponseList.class));
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Exception parsing url, indicating the requested URL is not correctly encoded. Please check the client application.", ex);
        }
        return this.xmlGenerator.generate(propFindResponses);
    }

    public PropertiesRequest parse(Element elProp) {
        HashSet<PropertiesRequest.Property> set = new HashSet<PropertiesRequest.Property>();
        for (Object o : elProp.getChildren()) {
            Element el;
            if (!(o instanceof Element) || !(el = (Element)o).getName().equals("property")) continue;
            QName name = this.getQName(el);
            Set<PropertiesRequest.Property> nested = this.parseChildren(el);
            PropertiesRequest.Property p = new PropertiesRequest.Property(name, nested);
            set.add(p);
        }
        return new PropertiesRequest(set);
    }

    private Set<PropertiesRequest.Property> parseChildren(Element elProp) {
        HashSet<PropertiesRequest.Property> set = new HashSet<PropertiesRequest.Property>();
        for (Object o : elProp.getChildren()) {
            Element el;
            if (!(o instanceof Element) || !(el = (Element)o).getName().equals("property")) continue;
            QName name = this.getQName(el);
            Set<PropertiesRequest.Property> nested = this.parseChildren(el);
            PropertiesRequest.Property p = new PropertiesRequest.Property(name, nested);
            set.add(p);
        }
        return set;
    }

    private QName getQName(Element el) {
        String local = el.getAttributeValue("name");
        String ns = el.getAttributeValue("namespace");
        if (ns == null) {
            ns = "DAV:";
        }
        return new QName(ns, local);
    }

    public String getName() {
        return "expand-property";
    }

    private PropFindResponseList toResponseList(String host, HrefList hrefList, PropertiesRequest.Property prop) throws URISyntaxException, NotAuthorizedException, BadRequestException {
        PropFindResponseList list = new PropFindResponseList();
        for (String href : hrefList) {
            Resource r = this.resourceFactory.getResource(host, href);
            if (r == null || !(r instanceof PropFindableResource)) continue;
            PropFindableResource pfr = (PropFindableResource)r;
            PropertiesRequest propertyRequest = new PropertiesRequest(prop.getNested());
            List propFindResponses = this.propertyBuilder.buildProperties(pfr, 0, propertyRequest, href);
            list.addAll((Collection)propFindResponses);
        }
        return list;
    }

    private void replaceHrefs(String host, PropFindResponseList propFindResponseList, PropertiesRequest.Property prop) throws URISyntaxException, NotAuthorizedException, BadRequestException {
        for (PropFindResponse r : propFindResponseList) {
            Set set = r.getKnownProperties().entrySet();
            set = new HashSet(set);
            for (Map.Entry p : set) {
                Object val = ((ValueAndType)p.getValue()).getValue();
                QName name = (QName)p.getKey();
                if (!(val instanceof HrefList)) continue;
                HrefList hrefList = (HrefList)val;
                PropertiesRequest.Property nestedProp = (PropertiesRequest.Property)prop.getNestedMap().get(name);
                if (nestedProp == null || nestedProp.getNested() == null || nestedProp.getNested().isEmpty()) continue;
                PropFindResponseList nestedList = this.toResponseList(host, hrefList, nestedProp);
                this.replaceHrefs(host, nestedList, nestedProp);
                r.getKnownProperties().remove(name);
                r.getKnownProperties().put(name, new ValueAndType((Object)nestedList, PropFindResponseList.class));
            }
        }
    }

    private void show(String prefix, List<PropFindResponse> propFindResponses) {
        for (PropFindResponse p : propFindResponses) {
            for (Map.Entry e : p.getKnownProperties().entrySet()) {
                Object o = ((ValueAndType)e.getValue()).getValue();
                if (!(o instanceof PropFindResponseList)) continue;
                PropFindResponseList childList = (PropFindResponseList)o;
                this.show(prefix + "   ", (List<PropFindResponse>)childList);
            }
        }
    }
}

