/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.caldav;

import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.caldav.EventResource;
import io.milton.http.caldav.EventResourceImpl;
import io.milton.http.caldav.ICalFormatter;
import io.milton.http.caldav.ITip;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.mail.MailboxAddress;
import io.milton.principal.CalDavPrincipal;
import io.milton.resource.CalendarResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.ICalResource;
import io.milton.resource.Resource;
import io.milton.resource.SchedulingResponseItem;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCalendarSearchService
implements CalendarSearchService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCalendarSearchService.class);
    private final ICalFormatter formatter;
    private final ResourceFactory resourceFactory;
    private String schedulingColName = "cals";
    private String inboxName = "inbox";
    private String outBoxName = "outbox";
    private String usersBasePath = "/users/";

    public DefaultCalendarSearchService(ICalFormatter formatter, ResourceFactory resourceFactory) {
        if (resourceFactory == null) {
            throw new NullPointerException("ResourceFactory is null");
        }
        this.formatter = formatter;
        this.resourceFactory = resourceFactory;
    }

    public List<ICalResource> findCalendarResources(CalendarResource calendar, Date start, Date end) throws NotAuthorizedException, BadRequestException {
        return this.findCalendarResources(calendar, start, end, null);
    }

    public List<ICalResource> findCalendarResources(CalendarResource calendar, Date start, Date end, AbstractMap.SimpleImmutableEntry<String, String> propFilter) throws NotAuthorizedException, BadRequestException {
        ArrayList<ICalResource> list = new ArrayList<ICalResource>();
        for (Resource r : calendar.getChildren()) {
            if (!(r instanceof ICalResource)) continue;
            ICalResource cr = (ICalResource)r;
            list.add(cr);
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Resource r;
            r = (ICalResource)it.next();
            if (this.outsideDates((ICalResource)r, start, end)) {
                log.info("Not in range: " + r.getName());
                it.remove();
            }
            StringReader sin = new StringReader(r.getICalData());
            CalendarBuilder builder = new CalendarBuilder();
            Calendar cal = null;
            try {
                cal = builder.build((Reader)sin);
            }
            catch (IOException e) {
                log.error("Exception building calendar from ics", (Throwable)e);
            }
            catch (ParserException e) {
                log.error("Unable to parse ics", (Throwable)e);
            }
            if (propFilter == null || cal.getComponent("VEVENT").getProperty(propFilter.getKey()).getValue().equals(propFilter.getValue())) continue;
            log.info("Event do not match properties filter");
            it.remove();
        }
        return list;
    }

    private boolean outsideDates(ICalResource r, Date start, Date end) {
        EventResource event;
        log.info("outsideDates: " + r.getName());
        if (r instanceof EventResource) {
            event = (EventResource)r;
        } else {
            event = new EventResourceImpl();
            try {
                this.formatter.parseEvent(event, r.getICalData());
            }
            catch (IOException | ParserException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (start != null && event.getStart().before(start)) {
            log.info(" before start: " + event.getStart() + " < " + start);
            return true;
        }
        if (end != null && event.getEnd().after(end)) {
            log.info(" after end: " + event.getEnd() + " < " + end);
            return true;
        }
        return false;
    }

    public List<SchedulingResponseItem> queryFreeBusy(CalDavPrincipal principal, String iCalText) {
        ICalFormatter.FreeBusyRequest r = this.formatter.parseFreeBusyRequest(iCalText);
        log.info("queryFreeBusy: attendees=" + r.getAttendeeLines().size() + " - " + r.getAttendeeMailtos().size());
        ArrayList<SchedulingResponseItem> list = new ArrayList<SchedulingResponseItem>();
        try {
            for (String attendeeMailto : r.getAttendeeMailtos()) {
                MailboxAddress add = MailboxAddress.parse((String)attendeeMailto);
                CalDavPrincipal attendee = this.findUserFromMailto(add);
                if (attendee == null) {
                    log.warn("Attendee not found: " + attendeeMailto);
                    SchedulingResponseItem item = new SchedulingResponseItem(attendeeMailto, ITip.StatusResponse.RS_INVALID_37, null);
                    list.add(item);
                    continue;
                }
                log.info("Found attendee: " + attendee.getName());
                String ical = this.buildFreeBusyAttendeeResponse(attendee, r, add.domain, attendeeMailto);
                SchedulingResponseItem item = new SchedulingResponseItem(attendeeMailto, ITip.StatusResponse.RS_SUCCESS_20, ical);
                list.add(item);
            }
        }
        catch (BadRequestException | NotAuthorizedException ex) {
            throw new RuntimeException(ex);
        }
        return list;
    }

    public List<ICalResource> findAttendeeResources(CalDavPrincipal user) throws NotAuthorizedException, BadRequestException {
        ArrayList<ICalResource> list = new ArrayList<ICalResource>();
        String host = HttpManager.request().getHostHeader();
        Resource rUsersHome = this.resourceFactory.getResource(host, this.usersBasePath);
        if (rUsersHome instanceof CollectionResource) {
            CollectionResource usersHome = (CollectionResource)rUsersHome;
            for (Resource rUser : usersHome.getChildren()) {
                if (!(rUser instanceof CalDavPrincipal)) continue;
                CalDavPrincipal p = (CalDavPrincipal)rUser;
                for (String href : p.getCalendarHomeSet()) {
                    Resource rCalHome = this.resourceFactory.getResource(host, href);
                    if (!(rCalHome instanceof CollectionResource)) continue;
                    CollectionResource calHome = (CollectionResource)rCalHome;
                    for (Resource rCal : calHome.getChildren()) {
                        if (!(rCal instanceof CalendarResource)) continue;
                        CalendarResource cal = (CalendarResource)rCal;
                        for (Resource rEvent : cal.getChildren()) {
                            ICalResource event;
                            if (!(rEvent instanceof ICalResource) || !this.isAttendeeOf(user, event = (ICalResource)rEvent)) continue;
                            list.add(event);
                        }
                    }
                }
            }
        }
        return list;
    }

    public String findAttendeeResourcesCTag(CalDavPrincipal attendee) throws NotAuthorizedException, BadRequestException {
        Date latest = null;
        for (ICalResource r : this.findAttendeeResources(attendee)) {
            Date d = r.getModifiedDate();
            if (latest != null && !d.after(latest)) continue;
            latest = d;
        }
        if (latest != null) {
            return "mod-" + latest.getTime();
        }
        return "na";
    }

    public String getSchedulingColName() {
        return this.schedulingColName;
    }

    public void setSchedulingColName(String schedulingColName) {
        this.schedulingColName = schedulingColName;
    }

    public String getSchedulingInboxColName() {
        return this.inboxName;
    }

    public void setSchedulingInboxColName(String inboxName) {
        this.inboxName = inboxName;
    }

    public String getSchedulingOutboxColName() {
        return this.outBoxName;
    }

    public void setSchedulingOutboxColName(String outBoxName) {
        this.outBoxName = outBoxName;
    }

    private CalDavPrincipal findUserFromMailto(MailboxAddress add) throws NotAuthorizedException, BadRequestException {
        String userPath = this.usersBasePath + add.user;
        Resource r = this.resourceFactory.getResource(add.domain, userPath);
        if (r == null) {
            log.warn("Failed to find: " + userPath + " in host: " + add.domain);
            return null;
        }
        if (r instanceof CalDavPrincipal) {
            return (CalDavPrincipal)r;
        }
        log.warn("findUserFromMailto: found a resource but it is not a CalDavPrincipal. Is a: " + r.getClass().getCanonicalName());
        return null;
    }

    public String getUsersBasePath() {
        return this.usersBasePath;
    }

    public void setUsersBasePath(String usersBasePath) {
        this.usersBasePath = usersBasePath;
    }

    private String buildFreeBusyAttendeeResponse(CalDavPrincipal attendee, ICalFormatter.FreeBusyRequest request, String domain, String attendeeMailto) throws NotAuthorizedException, BadRequestException {
        Map<String, String> source = request.getLines();
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN:VCALENDAR\n");
        sb.append("VERSION:2.0 PRODID:-//milton.io//CalDAV Server//EN\n");
        sb.append("METHOD:REPLY\n");
        sb.append("BEGIN:VFREEBUSY\n");
        sb.append(source.get("UID")).append("\n");
        sb.append(source.get("DTSTAMP")).append("\n");
        sb.append(source.get("DTSTART")).append("\n");
        sb.append(source.get("DTEND")).append("\n");
        sb.append(source.get("ORGANIZER")).append("\n");
        sb.append(request.getAttendeeLines().get(attendeeMailto)).append("\n");
        Date start = request.getStart();
        Date finish = request.getFinish();
        for (String href : attendee.getCalendarHomeSet()) {
            Resource rCalHome;
            if (log.isTraceEnabled()) {
                log.trace("Look for calendar home: " + href);
            }
            if ((rCalHome = this.resourceFactory.getResource(domain, href)) instanceof CollectionResource) {
                CollectionResource calHome = (CollectionResource)rCalHome;
                log.trace("Look for calendars in home");
                for (Resource rColCal : calHome.getChildren()) {
                    if (!(rColCal instanceof CalendarResource)) continue;
                    CalendarResource cal = (CalendarResource)rColCal;
                    List<ICalResource> eventsInRange = this.findCalendarResources(cal, start, finish, null);
                    if (log.isTraceEnabled()) {
                        log.trace("Process calendar: " + cal.getName() + " events in range=" + eventsInRange.size());
                        log.trace("  range= " + start + " - " + finish);
                    }
                    for (ICalResource event : eventsInRange) {
                        log.trace("Process event: " + event.getName());
                        EventResourceImpl er = new EventResourceImpl();
                        try {
                            this.formatter.parseEvent(er, event.getICalData());
                        }
                        catch (IOException | ParserException ex) {
                            throw new RuntimeException(ex);
                        }
                        sb.append("FREEBUSY;FBTYPE=BUSY:");
                        sb.append(this.formatter.formatDate(er.getStart()));
                        sb.append("/");
                        sb.append(this.formatter.formatDate(er.getEnd()));
                        sb.append("\n");
                    }
                }
                continue;
            }
            if (rCalHome == null) {
                log.warn("Didnt find calendar home: " + href + " in domain: " + domain);
                continue;
            }
            log.warn("Found a resource at the calendar home address, but it is not a CollectionResource. Is a: " + rCalHome.getClass());
        }
        sb.append("END:VFREEBUSY\n");
        sb.append("END:VCALENDAR\n");
        return sb.toString();
    }

    private boolean isAttendeeOf(CalDavPrincipal user, ICalResource event) {
        for (String mailto : this.formatter.parseAttendees(event.getICalData())) {
            MailboxAddress add = MailboxAddress.parse((String)mailto);
            if (!add.user.equals(user.getName())) continue;
            return true;
        }
        return false;
    }
}

