/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.caldav;

import io.milton.http.annotated.scheduling.SchedulingInboxResource;
import io.milton.http.annotated.scheduling.SchedulingOutboxResource;
import io.milton.http.webdav.ResourceTypeHelper;
import io.milton.resource.CalendarResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.ICalResource;
import io.milton.resource.Resource;
import io.milton.webdav.utils.LockUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarResourceTypeHelper
implements ResourceTypeHelper {
    private static final Logger log = LoggerFactory.getLogger(CalendarResourceTypeHelper.class);
    private final ResourceTypeHelper wrapped;

    public CalendarResourceTypeHelper(ResourceTypeHelper wrapped) {
        log.debug("CalendarResourceTypeHelper constructed :" + wrapped.getClass().getSimpleName());
        this.wrapped = wrapped;
    }

    public List<QName> getResourceTypes(Resource r) {
        QName qn;
        if (log.isTraceEnabled()) {
            log.trace("getResourceTypes:" + r.getClass().getCanonicalName());
        }
        if (r instanceof ICalResource && r instanceof CollectionResource) {
            log.warn("ICal Resource is a collection, this might cause issues with some caldav clients");
        }
        if (r instanceof ICalResource && r instanceof CalendarResource) {
            log.error("EEK!! Resource is both an ical resource (eg an event) and a calendar. Don't implement CalendarResource on events!");
        }
        ArrayList<QName> list = this.wrapped.getResourceTypes(r);
        if (r instanceof CalendarResource) {
            log.trace("getResourceTypes: is a calendar");
            qn = new QName("urn:ietf:params:xml:ns:caldav", "calendar");
            if (list == null) {
                list = new ArrayList<QName>();
            }
            list.add(qn);
        }
        if (r instanceof SchedulingInboxResource) {
            log.trace("getResourceTypes: is a schedule-inbox");
            qn = new QName("urn:ietf:params:xml:ns:caldav", "schedule-inbox");
            if (list == null) {
                list = new ArrayList();
            }
            list.add(qn);
        }
        if (r instanceof SchedulingOutboxResource) {
            log.trace("getResourceTypes: is a schedule-outbox");
            qn = new QName("urn:ietf:params:xml:ns:caldav", "schedule-outbox");
            if (list == null) {
                list = new ArrayList();
            }
            list.add(qn);
        }
        return list;
    }

    public List<String> getSupportedLevels(Resource r) {
        log.debug("getSupportedLevels");
        List list = this.wrapped.getSupportedLevels(r);
        LockUtils.add((List)list, (String)"3");
        LockUtils.add((List)list, (String)"calendar-access");
        LockUtils.add((List)list, (String)"calendarserver-principal-property-search");
        LockUtils.add((List)list, (String)"calendar-schedule");
        LockUtils.add((List)list, (String)"extended-mkcol");
        LockUtils.add((List)list, (String)"extended-mkcol");
        LockUtils.add((List)list, (String)"calendar-proxy");
        LockUtils.add((List)list, (String)"calendar-auto-schedule");
        LockUtils.add((List)list, (String)"schedule-inbox");
        LockUtils.add((List)list, (String)"schedule-outbox");
        return list;
    }
}

