/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.caldav;

import io.milton.common.Utils;
import io.milton.http.DateUtils;
import io.milton.http.HttpManager;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.report.QualifiedReport;
import io.milton.http.report.ReportUtils;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropertiesRequest;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.resource.CalendarResource;
import io.milton.resource.ICalResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarQueryReport
implements QualifiedReport {
    private static final Logger log = LoggerFactory.getLogger(CalendarQueryReport.class);
    private final PropFindPropertyBuilder propertyBuilder;
    private final PropFindXmlGenerator xmlGenerator;
    private final CalendarSearchService calendarSearchService;
    private final Namespace NS_DAV = Namespace.getNamespace((String)WebDavProtocol.NS_DAV.getPrefix(), (String)WebDavProtocol.NS_DAV.getName());
    private final Namespace NS_CAL = Namespace.getNamespace((String)"C", (String)"urn:ietf:params:xml:ns:caldav");

    public CalendarQueryReport(PropFindPropertyBuilder propertyBuilder, PropFindXmlGenerator xmlGenerator, CalendarSearchService calendarSearchService) {
        this.propertyBuilder = propertyBuilder;
        this.xmlGenerator = xmlGenerator;
        this.calendarSearchService = calendarSearchService;
    }

    public String getName() {
        return "calendar-query";
    }

    public QName getQualifiedName() {
        return new QName(this.NS_CAL.getURI(), this.getName());
    }

    public String process(String host, String path, Resource resource, Document doc) throws BadRequestException, NotAuthorizedException {
        log.debug("process");
        Set props = ReportUtils.getProps((Document)doc, (Namespace)this.NS_DAV);
        PropertiesRequest parseResult = PropertiesRequest.toProperties((Set)props);
        ArrayList respProps = new ArrayList();
        if (resource instanceof CalendarResource) {
            CalendarResource calendar = (CalendarResource)resource;
            List<ICalResource> foundResources = this.findCalendarResources(calendar, doc);
            if (foundResources != null) {
                log.trace("foundResources: " + foundResources.size());
            } else {
                log.trace("foundResources: null");
            }
            String parentHref = HttpManager.request().getAbsolutePath();
            parentHref = Utils.suffixSlash((String)parentHref);
            for (ICalResource cr : foundResources) {
                String href = parentHref + cr.getName();
                ArrayList resps = new ArrayList();
                this.propertyBuilder.processResource(resps, (PropFindableResource)cr, parseResult, href, 0, 0, href);
                respProps.addAll(resps);
            }
        } else {
            throw new BadRequestException(resource, "Resource is not a " + CalendarResource.class.getCanonicalName() + " is a: " + resource.getClass());
        }
        return this.xmlGenerator.generate(respProps);
    }

    private List<ICalResource> findCalendarResources(CalendarResource calendar, Document doc) throws NotAuthorizedException, BadRequestException {
        Date end;
        Date start;
        AbstractMap.SimpleImmutableEntry<String, String> propFilter = null;
        Element elFilterRoot = doc.getRootElement().getChild("filter", this.NS_CAL);
        if (elFilterRoot == null) {
            start = null;
            end = null;
        } else {
            Element elTimeRange;
            Element elPropFilter = ReportUtils.findRecursively((Element)elFilterRoot, (String)"prop-filter");
            if (elPropFilter != null) {
                Element elTextMatch = ReportUtils.find((Element)elPropFilter, (String)"text-match", (Namespace)this.NS_CAL);
                String filterAttr = ((Attribute)elPropFilter.getAttributes().get(0)).getValue();
                propFilter = new AbstractMap.SimpleImmutableEntry<String, String>(filterAttr, elTextMatch.getText());
            }
            if ((elTimeRange = ReportUtils.find((Element)elFilterRoot, (String)"time-range", (Namespace)this.NS_CAL)) == null) {
                start = null;
                end = null;
            } else {
                String sStart = elTimeRange.getAttributeValue("start");
                String sFinish = elTimeRange.getAttributeValue("end");
                if (sStart != null && sStart.length() > 0) {
                    try {
                        start = DateUtils.parseIcalDateTime((String)sStart);
                    }
                    catch (DateUtils.DateParseException ex) {
                        log.error("Couldnt parse start date in calendar-query: " + sStart);
                        start = null;
                    }
                } else {
                    start = null;
                }
                if (sFinish != null && sFinish.length() > 0) {
                    try {
                        end = DateUtils.parseIcalDateTime((String)sFinish);
                    }
                    catch (DateUtils.DateParseException ex) {
                        log.error("Couldnt parse end date in calendar-query: " + sFinish);
                        end = null;
                    }
                } else {
                    end = null;
                }
            }
        }
        log.info("Search calendar resources. Start=" + start + " End:" + end);
        return this.calendarSearchService.findCalendarResources(calendar, start, end, propFilter);
    }
}

