/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.caldav;

import io.milton.common.LogUtils;
import io.milton.http.Auth;
import io.milton.http.Handler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpExtension;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.WellKnownResourceFactory;
import io.milton.http.acl.ACLHandler;
import io.milton.http.caldav.ACLPrincipalPropSetReport;
import io.milton.http.caldav.CalendarQueryReport;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.caldav.MkCalendarHandler;
import io.milton.http.caldav.MultiGetReport;
import io.milton.http.caldav.PrincipalMatchReport;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.CustomPostHandler;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.http.report.Report;
import io.milton.http.values.HrefList;
import io.milton.http.values.SupportedCalendarComponentList;
import io.milton.http.values.SupportedCalendarComponentListsSet;
import io.milton.http.values.WrappedHref;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropertyMap;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.principal.CalDavPrincipal;
import io.milton.property.PropertySource;
import io.milton.resource.CalendarCollection;
import io.milton.resource.CalendarResource;
import io.milton.resource.DigestResource;
import io.milton.resource.GetableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import io.milton.webdav.utils.CalendarDataProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalDavProtocol
implements HttpExtension,
PropertySource,
WellKnownResourceFactory.WellKnownHandler {
    private static final Logger log = LoggerFactory.getLogger(CalDavProtocol.class);
    public static final String CALDAV_NS = "urn:ietf:params:xml:ns:caldav";
    public static final String CALSERVER_NS = "http://calendarserver.org/ns/";
    public static final String APPLE_ICAL_NS = "http://apple.com/ns/ical/";
    private final Set<Handler> handlers;
    private final PropertyMap propertyMapCalDav;
    private final PropertyMap propertyMapCalServer;
    private final PropertyMap propertyMapAppleCal;
    private final CalendarSearchService calendarSearchService;
    private final List<CustomPostHandler> customPostHandlers;
    private ResourceFactory resourceFactory;

    public CalDavProtocol(ResourceFactory resourceFactory, WebDavResponseHandler responseHandler, HandlerHelper handlerHelper, WebDavProtocol webDavProtocol, PropFindXmlGenerator gen, PropFindPropertyBuilder propertyBuilder, CalendarSearchService calendarSearchService) {
        if (resourceFactory == null) {
            throw new NullPointerException("resourceFactory is null");
        }
        this.resourceFactory = resourceFactory;
        this.calendarSearchService = calendarSearchService;
        this.propertyMapCalDav = new PropertyMap(CALDAV_NS);
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new CalenderDescriptionProperty());
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new CalenderUserTypeProperty());
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new CalendarOrderProperty());
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new CalendarDataProperty());
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new CalenderHomeSetProperty());
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new CalenderUserAddressSetProperty());
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new SupportedCalendarComponentSetProperty());
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new SupportedCalendarComponentSetsProperty());
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new ScheduleInboxProperty());
        this.propertyMapCalDav.add((PropertyMap.StandardProperty)new ScheduleOutboxProperty());
        this.propertyMapCalServer = new PropertyMap(CALSERVER_NS);
        this.propertyMapCalServer.add((PropertyMap.StandardProperty)new CTagProperty());
        this.propertyMapAppleCal = new PropertyMap(APPLE_ICAL_NS);
        this.propertyMapAppleCal.add((PropertyMap.StandardProperty)new ColorProperty());
        this.propertyMapAppleCal.add((PropertyMap.StandardProperty)new CalendarOrderProperty());
        this.handlers = new HashSet<Handler>();
        this.handlers.add(new ACLHandler(responseHandler, handlerHelper));
        this.handlers.add(new MkCalendarHandler(webDavProtocol.getMkColHandler(), webDavProtocol.getPropPatchHandler()));
        webDavProtocol.addPropertySource((PropertySource)this);
        webDavProtocol.addReport((Report)new MultiGetReport(resourceFactory, propertyBuilder, gen));
        webDavProtocol.addReport((Report)new ACLPrincipalPropSetReport());
        webDavProtocol.addReport((Report)new PrincipalMatchReport());
        webDavProtocol.addReport((Report)new CalendarQueryReport(propertyBuilder, gen, calendarSearchService));
        this.customPostHandlers = Collections.EMPTY_LIST;
    }

    public Set<Handler> getHandlers() {
        return Collections.unmodifiableSet(this.handlers);
    }

    public Object getProperty(QName name, Resource r) {
        log.trace("getProperty: {}", (Object)name.getLocalPart());
        Object o = this.propertyMapCalDav.hasProperty(name) ? this.propertyMapCalDav.getProperty(name, r) : (this.propertyMapAppleCal.hasProperty(name) ? this.propertyMapAppleCal.getProperty(name, r) : this.propertyMapCalServer.getProperty(name, r));
        if (log.isTraceEnabled()) {
            log.trace("getProperty result : " + o + " for property: " + name.getLocalPart());
        }
        return o;
    }

    public void setProperty(QName name, Object value, Resource r) {
        log.trace("setProperty: {}", (Object)name.getLocalPart());
        if (this.propertyMapCalDav.hasProperty(name)) {
            this.propertyMapCalDav.setProperty(name, r, value);
        } else if (this.propertyMapAppleCal.hasProperty(name)) {
            this.propertyMapAppleCal.setProperty(name, r, value);
        } else {
            this.propertyMapCalServer.setProperty(name, r, value);
        }
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        log.trace("getPropertyMetaData: {}", (Object)name.getLocalPart());
        if (this.propertyMapCalDav.hasProperty(name)) {
            return this.propertyMapCalDav.getPropertyMetaData(name, r);
        }
        if (this.propertyMapAppleCal.hasProperty(name)) {
            return this.propertyMapAppleCal.getPropertyMetaData(name, r);
        }
        return this.propertyMapCalServer.getPropertyMetaData(name, r);
    }

    public void clearProperty(QName name, Resource r) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<QName> getAllPropertyNames(Resource r) {
        log.trace("getAllPropertyNames");
        ArrayList<QName> list = new ArrayList<QName>();
        list.addAll(this.propertyMapCalDav.getAllPropertyNames(r));
        list.addAll(this.propertyMapCalServer.getAllPropertyNames(r));
        list.addAll(this.propertyMapAppleCal.getAllPropertyNames(r));
        return list;
    }

    public List<CustomPostHandler> getCustomPostHandlers() {
        return this.customPostHandlers;
    }

    public String getWellKnownName() {
        return "caldav";
    }

    public Resource locateWellKnownResource(Resource host) {
        log.trace("found a caldav well-known resource");
        return new CaldavWellKnownResource(host);
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public class CaldavWellKnownResource
    implements DigestResource,
    GetableResource,
    PropFindableResource {
        private final Resource host;

        public CaldavWellKnownResource(Resource host) {
            this.host = host;
        }

        public String getUniqueId() {
            return null;
        }

        public String getName() {
            return CalDavProtocol.this.getWellKnownName();
        }

        public Object authenticate(String user, String password) {
            return this.host.authenticate(user, password);
        }

        public boolean authorise(Request request, Request.Method method, Auth auth) {
            return auth != null;
        }

        public String getRealm() {
            return this.host.getRealm();
        }

        public Date getModifiedDate() {
            return null;
        }

        public String checkRedirect(Request request) {
            log.trace("well-known: checkRedirect");
            Auth auth = request.getAuthorization();
            if (auth != null && auth.getTag() != null) {
                if (auth.getTag() instanceof CalDavPrincipal) {
                    CalDavPrincipal p = (CalDavPrincipal)auth.getTag();
                    HrefList calendars = p.getCalendarHomeSet();
                    if (calendars == null || calendars.isEmpty()) {
                        log.warn("can't redirect, CalDavPrincipal.getCalendatHomeSet did not return an address. Check implementation class: " + p.getClass());
                        return null;
                    }
                    String first = (String)calendars.get(0);
                    LogUtils.trace((Logger)log, (Object[])new Object[]{"well-known: checkRedirect. redirecting to:", first});
                    return first;
                }
                log.warn("can't redirect, auth.getTag is not a CalDavPrincipal, is a: " + auth.getTag().getClass() + " To use CALDAV, the user object returned from authenticate must be a " + CalDavPrincipal.class);
                return null;
            }
            log.trace("can't redirect, no authorisation");
            return null;
        }

        public Object authenticate(DigestResponse digestRequest) {
            if (this.host instanceof DigestResource) {
                DigestResource dr = (DigestResource)this.host;
                return dr.authenticate(digestRequest);
            }
            return null;
        }

        public boolean isDigestAllowed() {
            if (this.host instanceof DigestResource) {
                DigestResource dr = (DigestResource)this.host;
                return dr.isDigestAllowed();
            }
            return false;
        }

        public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Long getMaxAgeSeconds(Auth auth) {
            return null;
        }

        public String getContentType(String accepts) {
            return null;
        }

        public Long getContentLength() {
            return null;
        }

        public Date getCreateDate() {
            return null;
        }
    }

    static class SupportedCalendarComponentSetProperty
    implements PropertyMap.WritableStandardProperty<SupportedCalendarComponentList> {
        SupportedCalendarComponentSetProperty() {
        }

        public String fieldName() {
            return "supported-calendar-component-set";
        }

        public SupportedCalendarComponentList getValue(PropFindableResource res) {
            if (res instanceof CalendarResource) {
                CalendarResource ccol = (CalendarResource)res;
                return ccol.getSupportedComponentSet();
            }
            return null;
        }

        public Class<SupportedCalendarComponentList> getValueClass() {
            return SupportedCalendarComponentList.class;
        }

        public void setValue(PropFindableResource res, SupportedCalendarComponentList value) {
        }
    }

    static class SupportedCalendarComponentSetsProperty
    implements PropertyMap.WritableStandardProperty<SupportedCalendarComponentListsSet> {
        SupportedCalendarComponentSetsProperty() {
        }

        public String fieldName() {
            return "supported-calendar-component-sets";
        }

        public SupportedCalendarComponentListsSet getValue(PropFindableResource res) {
            if (res instanceof CalDavPrincipal) {
                CalDavPrincipal ccol = (CalDavPrincipal)res;
                return ccol.getSupportedComponentSets();
            }
            return null;
        }

        public Class<SupportedCalendarComponentListsSet> getValueClass() {
            return SupportedCalendarComponentListsSet.class;
        }

        public void setValue(PropFindableResource res, SupportedCalendarComponentListsSet value) {
        }
    }

    static class CalendarOrderProperty
    implements PropertyMap.WritableStandardProperty<String> {
        public String fieldName() {
            return "calendar-order";
        }

        public String getValue(PropFindableResource res) {
            if (res instanceof CalendarResource) {
                CalendarResource ccol = (CalendarResource)res;
                return ccol.getCalendarOrder();
            }
            return null;
        }

        public Class getValueClass() {
            return String.class;
        }

        public void setValue(PropFindableResource res, String value) {
            if (res instanceof CalendarResource) {
                CalendarResource ccol = (CalendarResource)res;
                ccol.setCalendarOrder(value);
            }
        }
    }

    static class ColorProperty
    implements PropertyMap.WritableStandardProperty<String> {
        ColorProperty() {
        }

        public String fieldName() {
            return "calendar-color";
        }

        public String getValue(PropFindableResource res) {
            if (res instanceof CalendarResource) {
                CalendarResource ccol = (CalendarResource)res;
                return ccol.getColor();
            }
            return null;
        }

        public Class<String> getValueClass() {
            return String.class;
        }

        public void setValue(PropFindableResource res, String value) {
            if (res instanceof CalendarResource) {
                CalendarResource ccol = (CalendarResource)res;
                ccol.setColor(value);
            }
        }
    }

    static class CTagProperty
    implements PropertyMap.StandardProperty<String> {
        CTagProperty() {
        }

        public String fieldName() {
            return "getctag";
        }

        public String getValue(PropFindableResource res) {
            if (res instanceof CalendarCollection) {
                CalendarCollection ccol = (CalendarCollection)res;
                return ccol.getCTag();
            }
            return null;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }

    static class CalenderUserTypeProperty
    implements PropertyMap.StandardProperty {
        public String fieldName() {
            return "calendar-user-type";
        }

        public Object getValue(PropFindableResource res) {
            if (res instanceof CalDavPrincipal) {
                CalDavPrincipal p = (CalDavPrincipal)res;
                return p.getCalendarUserType();
            }
            return null;
        }

        public Class getValueClass() {
            return String.class;
        }
    }

    class ScheduleOutboxProperty
    implements PropertyMap.StandardProperty<WrappedHref> {
        ScheduleOutboxProperty() {
        }

        public String fieldName() {
            return "schedule-outbox-URL";
        }

        public WrappedHref getValue(PropFindableResource res) {
            if (res instanceof CalDavPrincipal) {
                CalDavPrincipal p = (CalDavPrincipal)res;
                String s = p.getPrincipalURL() + CalDavProtocol.this.calendarSearchService.getSchedulingColName() + "/" + CalDavProtocol.this.calendarSearchService.getSchedulingOutboxColName() + "/";
                return new WrappedHref(s);
            }
            return null;
        }

        public Class<WrappedHref> getValueClass() {
            return WrappedHref.class;
        }
    }

    class ScheduleInboxProperty
    implements PropertyMap.StandardProperty<WrappedHref> {
        ScheduleInboxProperty() {
        }

        public String fieldName() {
            return "schedule-inbox-URL";
        }

        public WrappedHref getValue(PropFindableResource res) {
            if (res instanceof CalDavPrincipal) {
                CalDavPrincipal p = (CalDavPrincipal)res;
                String s = p.getPrincipalURL() + CalDavProtocol.this.calendarSearchService.getSchedulingColName() + "/" + CalDavProtocol.this.calendarSearchService.getSchedulingInboxColName() + "/";
                return new WrappedHref(s);
            }
            return null;
        }

        public Class<WrappedHref> getValueClass() {
            return WrappedHref.class;
        }
    }

    static class CalenderUserAddressSetProperty
    implements PropertyMap.StandardProperty<HrefList> {
        CalenderUserAddressSetProperty() {
        }

        public String fieldName() {
            return "calendar-user-address-set";
        }

        public HrefList getValue(PropFindableResource res) {
            if (res instanceof CalDavPrincipal) {
                return ((CalDavPrincipal)res).getCalendarUserAddressSet();
            }
            return null;
        }

        public Class<HrefList> getValueClass() {
            return HrefList.class;
        }
    }

    static class CalenderHomeSetProperty
    implements PropertyMap.StandardProperty<HrefList> {
        CalenderHomeSetProperty() {
        }

        public String fieldName() {
            return "calendar-home-set";
        }

        public HrefList getValue(PropFindableResource res) {
            if (res instanceof CalDavPrincipal) {
                return ((CalDavPrincipal)res).getCalendarHomeSet();
            }
            return null;
        }

        public Class<HrefList> getValueClass() {
            return HrefList.class;
        }
    }

    static class CalenderDescriptionProperty
    implements PropertyMap.StandardProperty<String> {
        CalenderDescriptionProperty() {
        }

        public String fieldName() {
            return "calendar-description";
        }

        public String getValue(PropFindableResource res) {
            if (res instanceof CalendarResource) {
                CalendarResource ical = (CalendarResource)res;
                return ical.getCalendarDescription();
            }
            log.warn("getValue: not a ICalResource");
            return null;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
}

