/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.caldav;

import io.milton.http.annotated.AnnoCalendarResource;
import io.milton.http.annotated.AnnoPrincipalResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.principal.CalDavPrincipal;
import io.milton.resource.CalendarResource;
import io.milton.resource.ICalResource;
import io.milton.resource.SchedulingResponseItem;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsCalendarSearchService
implements CalendarSearchService {
    private static final Logger log = LoggerFactory.getLogger(AnnotationsCalendarSearchService.class);
    private final CalendarSearchService wrapped;
    private AnnotationResourceFactory annotationResourceFactory;

    public AnnotationsCalendarSearchService(CalendarSearchService wrapped) {
        this.wrapped = wrapped;
    }

    public void setAnnotationResourceFactory(AnnotationResourceFactory annotationResourceFactory) {
        this.annotationResourceFactory = annotationResourceFactory;
    }

    public AnnotationResourceFactory getAnnotationResourceFactory() {
        return this.annotationResourceFactory;
    }

    public List<ICalResource> findCalendarResources(CalendarResource calendar, Date start, Date finish) throws NotAuthorizedException, BadRequestException {
        return this.findCalendarResources(calendar, start, finish, null);
    }

    public List<ICalResource> findCalendarResources(CalendarResource calendar, Date start, Date finish, AbstractMap.SimpleImmutableEntry<String, String> propFilter) throws NotAuthorizedException, BadRequestException {
        List results = null;
        if (calendar instanceof AnnoCalendarResource && (results = this.annotationResourceFactory.getCalendarDateRangeQueryAnnotationHandler().execute((AnnoCalendarResource)calendar, start, finish)) == null) {
            log.trace("Got null results from annotations calendar date range query, so will fallback to iterative query: " + this.wrapped.getClass());
        }
        if (results == null) {
            results = this.wrapped.findCalendarResources(calendar, start, finish, null);
        }
        return results;
    }

    public List<SchedulingResponseItem> queryFreeBusy(CalDavPrincipal principal, String iCalText) {
        if (principal instanceof AnnoPrincipalResource) {
            AnnoPrincipalResource p = (AnnoPrincipalResource)principal;
            List list = this.annotationResourceFactory.getFreeBusyQueryAnnotationHandler().execute(p, iCalText);
            if (list == null) {
                log.warn("Got null response from getFreeBusyQueryAnnotationHandler");
                list = Collections.EMPTY_LIST;
            }
            return list;
        }
        return this.wrapped.queryFreeBusy(principal, iCalText);
    }

    public List<ICalResource> findAttendeeResources(CalDavPrincipal principal) throws NotAuthorizedException, BadRequestException {
        if (principal instanceof AnnoPrincipalResource) {
            AnnoPrincipalResource p = (AnnoPrincipalResource)principal;
            return this.annotationResourceFactory.getCalendarInvitationsAnnotationHandler().getCalendarInvitations(p);
        }
        return this.wrapped.findAttendeeResources(principal);
    }

    public String findAttendeeResourcesCTag(CalDavPrincipal principal) throws NotAuthorizedException, BadRequestException {
        if (principal instanceof AnnoPrincipalResource) {
            AnnoPrincipalResource p = (AnnoPrincipalResource)principal;
            return this.annotationResourceFactory.getCalendarInvitationsCTagAnnotationHandler().getCalendarInvitationsCtag(p);
        }
        return this.wrapped.findAttendeeResourcesCTag(principal);
    }

    public String getSchedulingColName() {
        return this.wrapped.getSchedulingColName();
    }

    public String getSchedulingInboxColName() {
        return this.wrapped.getSchedulingInboxColName();
    }

    public String getSchedulingOutboxColName() {
        return this.wrapped.getSchedulingOutboxColName();
    }

    public CalendarSearchService getWrapped() {
        return this.wrapped;
    }
}

