/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.acl;

import io.milton.http.caldav.CalendarQueryReport;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.report.Report;
import io.milton.http.report.ReportUtils;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropertiesRequest;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.principal.DiscretePrincipal;
import io.milton.principal.PrincipalSearchCriteria;
import io.milton.principal.PrincipalSearchService;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalPropertySearchReport
implements Report {
    private static final Logger log = LoggerFactory.getLogger(CalendarQueryReport.class);
    private final PropFindPropertyBuilder propertyBuilder;
    private final PropFindXmlGenerator xmlGenerator;
    private final PrincipalSearchService principalSearchService;
    private final Namespace NS_DAV = Namespace.getNamespace((String)WebDavProtocol.NS_DAV.getPrefix(), (String)WebDavProtocol.NS_DAV.getName());
    private final Namespace NS_CAL = Namespace.getNamespace((String)"C", (String)"urn:ietf:params:xml:ns:caldav");

    public PrincipalPropertySearchReport(PropFindPropertyBuilder propertyBuilder, PropFindXmlGenerator xmlGenerator, PrincipalSearchService principalSearchService) {
        this.propertyBuilder = propertyBuilder;
        this.xmlGenerator = xmlGenerator;
        this.principalSearchService = principalSearchService;
    }

    public String getName() {
        return "principal-property-search";
    }

    public String process(String host, String path, Resource r, Document doc) throws BadRequestException, NotAuthorizedException {
        log.debug("process");
        Set<QName> props = this.getProps(doc);
        PropertiesRequest parseResult = PropertiesRequest.toProperties(props);
        ArrayList respProps = new ArrayList();
        PrincipalSearchCriteria crit = new PrincipalSearchCriteria();
        ArrayList<PrincipalSearchCriteria.SearchItem> searchTerms = new ArrayList<PrincipalSearchCriteria.SearchItem>();
        for (Element el : ReportUtils.findAll((Element)doc.getRootElement(), (String)"property-search", (Namespace)this.NS_DAV)) {
            Object field = null;
            Element elProp = ReportUtils.find((Element)el, (String)"prop", (Namespace)this.NS_DAV);
            Iterator propIter = elProp.getContent((Filter)new ElementFilter()).iterator();
            if (propIter.hasNext()) {
                Element elPropChild = (Element)propIter.next();
                QName qname = new QName(elPropChild.getNamespaceURI(), elPropChild.getName());
                field = qname.toString();
                if (propIter.hasNext()) {
                    log.warn("Multiple children of property-search/prop element not supported");
                }
            } else {
                log.warn("property-search/prop element has no children");
            }
            Element elMatch = ReportUtils.find((Element)el, (String)"match", (Namespace)this.NS_DAV);
            PrincipalSearchCriteria.MatchType matchType = PrincipalSearchCriteria.MatchType.CONTAINS;
            String matchAttr = elMatch.getAttributeValue("match-type");
            if (matchAttr != null) {
                matchType = PrincipalSearchCriteria.MatchType.fromCode((String)matchAttr);
            }
            String matchVal = elMatch.getText();
            PrincipalSearchCriteria.SearchItem item = new PrincipalSearchCriteria.SearchItem();
            item.setField((String)field);
            item.setMatchType(matchType);
            item.setValue(matchVal);
            searchTerms.add(item);
        }
        crit.setSearchItems(searchTerms);
        crit.setCuType(null);
        String typeAttr = doc.getRootElement().getAttributeValue("test");
        crit.setTest(PrincipalSearchCriteria.TestType.fromCode((String)typeAttr));
        List foundResources = this.principalSearchService.search(crit, r);
        if (foundResources != null) {
            log.info("foundResources: " + foundResources.size());
        } else {
            log.info("foundResources: null");
        }
        for (DiscretePrincipal dp : foundResources) {
            String href = dp.getPrincipalURL();
            ArrayList resps = new ArrayList();
            if (dp instanceof PropFindableResource) {
                PropFindableResource pfr = (PropFindableResource)dp;
                this.propertyBuilder.processResource(resps, pfr, parseResult, href, 0, 0, href);
            }
            respProps.addAll(resps);
        }
        String xml = this.xmlGenerator.generate(respProps);
        log.debug(xml);
        return xml;
    }

    private Set<QName> getProps(Document doc) {
        Element elProp = doc.getRootElement().getChild("prop", this.NS_DAV);
        if (elProp == null) {
            throw new RuntimeException("No prop element");
        }
        HashSet<QName> set = new HashSet<QName>();
        for (Object o : elProp.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            String local = el.getName();
            String ns = el.getNamespaceURI();
            set.add(new QName(ns, local, el.getNamespacePrefix()));
        }
        return set;
    }
}

