/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.acl;

import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoPrincipalResource;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.principal.DiscretePrincipal;
import io.milton.principal.PrincipalSearchCriteria;
import io.milton.principal.PrincipalSearchService;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsPrincipalSearchService
implements PrincipalSearchService {
    private static final Logger log = LoggerFactory.getLogger(AnnotationsPrincipalSearchService.class);
    private AnnotationResourceFactory arf;

    public List<DiscretePrincipal> search(PrincipalSearchCriteria criteria, Resource resource) throws BadRequestException, NotAuthorizedException {
        log.info("search. Resource=" + resource + "Criteria:" + criteria);
        if (resource instanceof AnnoResource) {
            AnnoResource cr = (AnnoResource)resource;
            List usersCol = this.arf.getUsersAnnotationHandler().findUsersCollections(cr.getRoot());
            if (usersCol == null) {
                log.warn("No users collection found");
                return null;
            }
            ArrayList<DiscretePrincipal> results = new ArrayList<DiscretePrincipal>();
            for (AnnoCollectionResource r : usersCol) {
                block1: for (Resource u : r.getChildren()) {
                    if (!(u instanceof AnnoPrincipalResource)) continue;
                    AnnoPrincipalResource dp = (AnnoPrincipalResource)u;
                    for (PrincipalSearchCriteria.SearchItem item : criteria.getSearchItems()) {
                        String searchVal = item.getValue();
                        log.info("Search val=" + searchVal);
                        if (!this.isMatch(dp, searchVal)) continue;
                        results.add((DiscretePrincipal)dp);
                        continue block1;
                    }
                }
            }
            return results;
        }
        log.warn("resource is not a AnnoResource, so can search");
        return null;
    }

    private boolean isMatch(AnnoPrincipalResource dp, String searchVal) {
        String dname = dp.getDisplayName();
        String email = dp.getEmail();
        StringBuilder sb = new StringBuilder();
        if (dname != null) {
            sb.append(dname.toLowerCase());
        }
        if (email != null) {
            sb.append(" ");
            sb.append(email.toLowerCase());
        }
        return sb.toString().contains(searchVal.toLowerCase());
    }

    public AnnotationResourceFactory getAnnotationResourceFactory() {
        return this.arf;
    }

    public void setAnnotationResourceFactory(AnnotationResourceFactory arf) {
        this.arf = arf;
    }
}

