/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.acl;

import io.milton.common.LogUtils;
import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.acl.PrincipalFactory;
import io.milton.principal.Principal;
import io.milton.property.PropertyAuthoriser;
import io.milton.resource.AccessControlledResource;
import io.milton.resource.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclAuthorisor
implements PropertyAuthoriser {
    private static final Logger log = LoggerFactory.getLogger(AclAuthorisor.class);
    private final PrincipalFactory principalFactory;

    public AclAuthorisor(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    public Boolean authorise(Request request, Request.Method method, Auth auth, Resource resource) {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"authorise", request.getAbsoluteUrl(), method.code, auth.getUser(), resource.getName()});
        if (resource instanceof AccessControlledResource) {
            AccessControlledResource acr = (AccessControlledResource)resource;
            Map privs = acr.getAccessControlList();
            if (privs == null) {
                return null;
            }
            Principal currentPrincipal = this.principalFactory.fromAuth(auth);
            List list = (List)privs.get(currentPrincipal);
            for (AccessControlledResource.Priviledge p : list) {
                if (method.isWrite) {
                    if (!p.equals((Object)AccessControlledResource.Priviledge.WRITE)) continue;
                    log.trace("found write permission");
                    return true;
                }
                if (!p.equals((Object)AccessControlledResource.Priviledge.READ)) continue;
                log.trace("found read permission");
                return true;
            }
            log.trace("did not find applicable permission");
            return false;
        }
        return null;
    }

    public Set<PropertyAuthoriser.CheckResult> checkPermissions(Request request, Request.Method method, PropertyAuthoriser.PropertyPermission perm, Set<QName> fields, Resource resource) {
        return null;
    }
}

