/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.acl;

import io.milton.http.Auth;
import io.milton.http.Handler;
import io.milton.http.HttpExtension;
import io.milton.http.HttpManager;
import io.milton.http.acl.PrincipalPropertySearchReport;
import io.milton.http.caldav.PrincipalSearchPropertySetReport;
import io.milton.http.http11.CustomPostHandler;
import io.milton.http.report.Report;
import io.milton.http.values.HrefList;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropertyMap;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.principal.DiscretePrincipal;
import io.milton.principal.PrincipalSearchService;
import io.milton.principal.PriviledgeList;
import io.milton.property.PropertySource;
import io.milton.resource.AccessControlledResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLProtocol
implements HttpExtension,
PropertySource {
    private static final Logger log = LoggerFactory.getLogger(ACLProtocol.class);
    private final PropertyMap propertyMap = new PropertyMap(WebDavProtocol.NS_DAV.getName());

    public ACLProtocol(WebDavProtocol webDavProtocol, PropFindPropertyBuilder propertyBuilder, PropFindXmlGenerator xmlGenerator, PrincipalSearchService principalSearchService) {
        this.propertyMap.add((PropertyMap.StandardProperty)new PrincipalUrl());
        this.propertyMap.add((PropertyMap.StandardProperty)new PrincipalCollectionSetProperty());
        this.propertyMap.add((PropertyMap.StandardProperty)new CurrentUserPrincipalProperty());
        this.propertyMap.add((PropertyMap.StandardProperty)new CurrentUserPrivledges());
        log.debug("registering the ACLProtocol as a property source");
        webDavProtocol.addPropertySource((PropertySource)this);
        webDavProtocol.addReport((Report)new PrincipalSearchPropertySetReport());
        webDavProtocol.addReport((Report)new PrincipalPropertySearchReport(propertyBuilder, xmlGenerator, principalSearchService));
    }

    public Set<Handler> getHandlers() {
        return Collections.EMPTY_SET;
    }

    public Object getProperty(QName name, Resource r) {
        log.debug("getProperty: " + name.getLocalPart());
        return this.propertyMap.getProperty(name, r);
    }

    public void setProperty(QName name, Object value, Resource r) {
        log.debug("setProperty: " + name.getLocalPart());
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        log.debug("getPropertyMetaData: " + name.getLocalPart());
        return this.propertyMap.getPropertyMetaData(name, r);
    }

    public void clearProperty(QName name, Resource r) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<QName> getAllPropertyNames(Resource r) {
        log.debug("getAllPropertyNames");
        ArrayList<QName> list = new ArrayList<QName>(this.propertyMap.getAllPropertyNames(r));
        return list;
    }

    public List<CustomPostHandler> getCustomPostHandlers() {
        return null;
    }

    static class CurrentUserPrivledges
    implements PropertyMap.StandardProperty<PriviledgeList> {
        CurrentUserPrivledges() {
        }

        public String fieldName() {
            return "current-user-privilege-set";
        }

        public PriviledgeList getValue(PropFindableResource res) {
            if (res instanceof AccessControlledResource) {
                AccessControlledResource acr = (AccessControlledResource)res;
                Auth auth = HttpManager.request().getAuthorization();
                List list = acr.getPriviledges(auth);
                return new PriviledgeList(list);
            }
            return null;
        }

        public Class<PriviledgeList> getValueClass() {
            return PriviledgeList.class;
        }
    }

    static class CurrentUserPrincipalProperty
    implements PropertyMap.StandardProperty<HrefList> {
        CurrentUserPrincipalProperty() {
        }

        public String fieldName() {
            return "current-user-principal";
        }

        public HrefList getValue(PropFindableResource res) {
            Auth auth = HttpManager.request().getAuthorization();
            if (auth == null || auth.getTag() == null) {
                return null;
            }
            Object user = auth.getTag();
            if (user instanceof DiscretePrincipal) {
                DiscretePrincipal p = (DiscretePrincipal)user;
                HrefList hrefs = new HrefList();
                hrefs.add((Object)p.getPrincipalURL());
                return hrefs;
            }
            return null;
        }

        public Class<HrefList> getValueClass() {
            return HrefList.class;
        }
    }

    static class PrincipalCollectionSetProperty
    implements PropertyMap.StandardProperty<HrefList> {
        PrincipalCollectionSetProperty() {
        }

        public String fieldName() {
            return "principal-collection-set";
        }

        public HrefList getValue(PropFindableResource res) {
            if (res instanceof AccessControlledResource) {
                AccessControlledResource acr = (AccessControlledResource)res;
                return acr.getPrincipalCollectionHrefs();
            }
            return null;
        }

        public Class<HrefList> getValueClass() {
            return HrefList.class;
        }
    }

    static class PrincipalUrl
    implements PropertyMap.StandardProperty<HrefList> {
        PrincipalUrl() {
        }

        public String fieldName() {
            return "principal-URL";
        }

        public HrefList getValue(PropFindableResource res) {
            if (res instanceof AccessControlledResource) {
                AccessControlledResource acr = (AccessControlledResource)res;
                String url = acr.getPrincipalURL();
                if (url != null) {
                    HrefList listOfOne = new HrefList();
                    listOfOne.add((Object)url);
                    return listOfOne;
                }
                return null;
            }
            log.warn("requested property 'principal-url', but resource doesnt implement AccessControlledResource: " + res.getClass().getCanonicalName());
            return null;
        }

        public Class<HrefList> getValueClass() {
            return HrefList.class;
        }
    }
}

