/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ent.config;

import io.milton.config.HttpManagerBuilder;
import io.milton.http.HttpExtension;
import io.milton.http.LockManager;
import io.milton.http.ProtocolHandlers;
import io.milton.http.WellKnownResourceFactory;
import io.milton.http.acl.ACLProtocol;
import io.milton.http.acl.AccessControlledResourceTypeHelper;
import io.milton.http.acl.AnnotationsPrincipalSearchService;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.caldav.AnnotationsCalendarSearchService;
import io.milton.http.caldav.CalDavProtocol;
import io.milton.http.caldav.CalendarResourceTypeHelper;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.caldav.DefaultCalendarSearchService;
import io.milton.http.caldav.ICalFormatter;
import io.milton.http.caldav.SupportedCalendarComponentListValueWriter;
import io.milton.http.caldav.SupportedCalendarComponentListsSetValueWriter;
import io.milton.http.carddav.AddressBookResourceTypeHelper;
import io.milton.http.carddav.CardDavProtocol;
import io.milton.http.fck.FckResourceFactory;
import io.milton.http.fs.SimpleLockManager;
import io.milton.http.http11.Http11Protocol;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.http11.MatchHelper;
import io.milton.http.http11.PartialGetHelper;
import io.milton.http.webdav.PropertySourcePatchSetter;
import io.milton.http.webdav.ResourceTypeHelper;
import io.milton.http.webdav.WebDavResourceTypeHelper;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.http.webdav2.LockTokenValueWriter;
import io.milton.http.webdav2.SupportedLockValueWriter;
import io.milton.http.webdav2.WebDavLevel2Protocol;
import io.milton.http.webdav2.WebDavLevel2ResourceTypeHelper;
import io.milton.principal.PrincipalSearchService;
import io.milton.property.PropertySource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpManagerBuilderEnt
extends HttpManagerBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpManagerBuilderEnt.class);
    private List<WellKnownResourceFactory.WellKnownHandler> wellKnownHandlers;
    private CalDavProtocol calDavProtocol;
    private CardDavProtocol cardDavProtocol;
    private ACLProtocol aclProtocol;
    private boolean caldavEnabled = true;
    private boolean carddavEnabled = true;
    private boolean aclEnabled = true;
    private boolean enableWellKnown = true;
    private WebDavLevel2Protocol webDavLevel2Protocol;
    private boolean webdavLevel2Enabled = true;
    private LockManager lockManager;
    private ICalFormatter iCalFormatter;
    private CalendarSearchService calendarSearchService;
    private AnnotationsCalendarSearchService annotationsCalendarSearchService;
    private PrincipalSearchService principalSearchService;
    private AnnotationsPrincipalSearchService annotationsPrincipalSearchService;
    private WellKnownResourceFactory wellKnownResourceFactory;

    protected void afterInit() {
        super.afterInit();
        if (this.getMainResourceFactory() instanceof AnnotationResourceFactory) {
            AnnotationResourceFactory arf = (AnnotationResourceFactory)this.getMainResourceFactory();
            if (arf.getLockManager() == null) {
                if (this.lockManager == null) {
                    this.lockManager = new SimpleLockManager(this.getCacheManager());
                    log.info("Created lock manager: {} with cache manager: {}", (Object)this.lockManager, (Object)this.getCacheManager());
                } else {
                    log.info("Using configured cache manager: {}", (Object)this.lockManager);
                }
                arf.setLockManager(this.lockManager);
            } else {
                log.info("Using LockManager from AnnotationResourceFactory: {}", arf.getLockManager().getClass());
            }
            if (this.annotationsCalendarSearchService != null) {
                this.annotationsCalendarSearchService.setAnnotationResourceFactory(arf);
            }
            arf.setCalendarSearchService(this.calendarSearchService);
            if (this.annotationsPrincipalSearchService != null) {
                this.annotationsPrincipalSearchService.setAnnotationResourceFactory(arf);
            }
        }
    }

    protected void buildOuterResourceFactory() {
        log.info("buildOuterResourceFactory");
        if (this.outerResourceFactory == null) {
            this.outerResourceFactory = this.mainResourceFactory;
            if (this.enabledJson) {
                this.outerResourceFactory = this.buildJsonResourceFactory();
                log.info("Enabled json/ajax gateway with: {}", this.outerResourceFactory.getClass());
            }
            if (this.enableWellKnown) {
                this.wellKnownResourceFactory = new WellKnownResourceFactory(this.outerResourceFactory);
                this.outerResourceFactory = this.wellKnownResourceFactory;
                log.info("Enabled well-known protocol support with: {}", this.outerResourceFactory.getClass());
            }
            if (this.calendarSearchService == null) {
                log.warn("Using the default calendar search service. Calendar search functions may exhibit poor performance. If thats a problem implement your own: {}", CalendarSearchService.class);
                if (this.iCalFormatter == null) {
                    this.iCalFormatter = new ICalFormatter();
                }
                DefaultCalendarSearchService c = new DefaultCalendarSearchService(this.iCalFormatter, this.mainResourceFactory);
                this.annotationsCalendarSearchService = new AnnotationsCalendarSearchService(c);
                this.calendarSearchService = this.annotationsCalendarSearchService;
            }
            if (this.principalSearchService == null) {
                this.annotationsPrincipalSearchService = new AnnotationsPrincipalSearchService();
                this.principalSearchService = this.annotationsPrincipalSearchService;
            }
            if (this.enabledCkBrowser) {
                this.outerResourceFactory = new FckResourceFactory(this.outerResourceFactory);
                log.info("Enabled CK Editor support with: " + this.outerResourceFactory.getClass());
            }
        }
    }

    protected void buildResourceTypeHelper() {
        WebDavResourceTypeHelper webDavResourceTypeHelper = new WebDavResourceTypeHelper();
        WebDavLevel2ResourceTypeHelper davLevel2ResourceTypeHelper = new WebDavLevel2ResourceTypeHelper((ResourceTypeHelper)webDavResourceTypeHelper);
        AccessControlledResourceTypeHelper accessControlledResourceTypeHelper = new AccessControlledResourceTypeHelper(davLevel2ResourceTypeHelper);
        CalendarResourceTypeHelper calendarResourceTypeHelper = new CalendarResourceTypeHelper(accessControlledResourceTypeHelper);
        this.resourceTypeHelper = new AddressBookResourceTypeHelper(calendarResourceTypeHelper);
    }

    protected void buildProtocolHandlers(WebDavResponseHandler webdavResponseHandler, ResourceTypeHelper resourceTypeHelper) {
        if (this.protocols == null) {
            this.protocols = new ArrayList();
            if (this.matchHelper == null) {
                this.matchHelper = new MatchHelper(this.eTagGenerator);
            }
            if (this.partialGetHelper == null) {
                this.partialGetHelper = new PartialGetHelper();
            }
            Http11Protocol http11Protocol = new Http11Protocol((Http11ResponseHandler)webdavResponseHandler, this.handlerHelper, this.resourceHandlerHelper, this.enableOptionsAuth, this.matchHelper, this.partialGetHelper);
            log.info("Enabled HTTP11 protocol");
            this.protocols.add(http11Protocol);
            this.initDefaultPropertySources(resourceTypeHelper);
            if (this.extraPropertySources != null) {
                for (PropertySource ps : this.extraPropertySources) {
                    log.info("Add extra property source: {}", ps.getClass());
                    this.propertySources.add(ps);
                }
            }
            if (this.propPatchSetter == null) {
                this.propPatchSetter = new PropertySourcePatchSetter(this.propertySources);
            }
            this.initWebdavProtocol();
            if (this.webDavProtocol != null) {
                log.info("Enabled DAV level 1 protocol");
                this.protocols.add(this.webDavProtocol);
            }
            if (this.webDavLevel2Protocol == null && this.webdavLevel2Enabled) {
                this.webDavLevel2Protocol = new WebDavLevel2Protocol(this.handlerHelper, webdavResponseHandler, this.resourceHandlerHelper, this.userAgentHelper());
            }
            if (this.webDavLevel2Protocol != null) {
                log.info("Enabled DAV level 2 protocol");
                this.valueWriters.getValueWriters().add(0, new SupportedLockValueWriter());
                this.valueWriters.getValueWriters().add(0, new LockTokenValueWriter());
                this.protocols.add(this.webDavLevel2Protocol);
                if (this.webDavProtocol != null) {
                    this.webDavProtocol.addPropertySource((PropertySource)this.webDavLevel2Protocol);
                }
            }
            if (this.calDavProtocol == null && this.caldavEnabled) {
                this.calDavProtocol = new CalDavProtocol(this.outerResourceFactory, webdavResponseHandler, this.handlerHelper, this.webDavProtocol, this.propFindXmlGenerator, this.propFindPropertyBuilder(), this.calendarSearchService);
            }
            if (this.calDavProtocol != null) {
                log.info("Add Caldav protocol: {} with resource factory: {}", this.calDavProtocol.getClass(), (Object)this.calDavProtocol.getResourceFactory());
                this.protocols.add(this.calDavProtocol);
            }
            if (this.aclProtocol == null && this.aclEnabled) {
                this.aclProtocol = new ACLProtocol(this.webDavProtocol, this.propFindPropertyBuilder(), this.propFindXmlGenerator, this.principalSearchService);
            }
            if (this.aclProtocol != null) {
                log.info("Enaled ACL Protocol");
                this.protocols.add(this.aclProtocol);
            }
            if (this.cardDavProtocol == null && this.carddavEnabled) {
                this.cardDavProtocol = new CardDavProtocol(this.mainResourceFactory, webdavResponseHandler, this.handlerHelper, this.webDavProtocol, this.propFindXmlGenerator, this.propFindPropertyBuilder());
            }
            if (this.cardDavProtocol != null) {
                this.valueWriters.getValueWriters().add(0, new SupportedCalendarComponentListValueWriter());
                this.valueWriters.getValueWriters().add(0, new SupportedCalendarComponentListsSetValueWriter());
                this.protocols.add(this.cardDavProtocol);
                log.info("Enabled CardDav protocol");
            }
        }
        if (this.protocolHandlers == null) {
            this.protocolHandlers = new ProtocolHandlers((List)this.protocols);
        }
        if (this.wellKnownResourceFactory != null) {
            log.info("Enabled well-known protocol");
            if (this.wellKnownHandlers == null) {
                this.wellKnownHandlers = new ArrayList<WellKnownResourceFactory.WellKnownHandler>();
                for (HttpExtension p : this.protocols) {
                    if (!(p instanceof WellKnownResourceFactory.WellKnownHandler)) continue;
                    WellKnownResourceFactory.WellKnownHandler wellKnownHandler = (WellKnownResourceFactory.WellKnownHandler)p;
                    this.wellKnownHandlers.add(wellKnownHandler);
                }
            }
            this.wellKnownResourceFactory.setWellKnownHandlers(this.wellKnownHandlers);
        }
    }

    public List<WellKnownResourceFactory.WellKnownHandler> getWellKnownHandlers() {
        return this.wellKnownHandlers;
    }

    public void setWellKnownHandlers(List<WellKnownResourceFactory.WellKnownHandler> wellKnownHandlers) {
        this.wellKnownHandlers = wellKnownHandlers;
    }

    public boolean isEnableWellKnown() {
        return this.enableWellKnown;
    }

    public void setEnableWellKnown(boolean enableWellKnown) {
        this.enableWellKnown = enableWellKnown;
    }

    public CalDavProtocol getCalDavProtocol() {
        return this.calDavProtocol;
    }

    public void setCalDavProtocol(CalDavProtocol calDavProtocol) {
        this.calDavProtocol = calDavProtocol;
    }

    public CardDavProtocol getCardDavProtocol() {
        return this.cardDavProtocol;
    }

    public void setCardDavProtocol(CardDavProtocol cardDavProtocol) {
        this.cardDavProtocol = cardDavProtocol;
    }

    public ACLProtocol getAclProtocol() {
        return this.aclProtocol;
    }

    public void setAclProtocol(ACLProtocol aclProtocol) {
        this.aclProtocol = aclProtocol;
    }

    public boolean isAclEnabled() {
        return this.aclEnabled;
    }

    public void setAclEnabled(boolean aclEnabled) {
        this.aclEnabled = aclEnabled;
    }

    public boolean isCaldavEnabled() {
        return this.caldavEnabled;
    }

    public void setCaldavEnabled(boolean caldavEnabled) {
        this.caldavEnabled = caldavEnabled;
    }

    public boolean isCarddavEnabled() {
        return this.carddavEnabled;
    }

    public void setCarddavEnabled(boolean carddavEnabled) {
        this.carddavEnabled = carddavEnabled;
    }

    public WebDavLevel2Protocol getWebDavLevel2Protocol() {
        return this.webDavLevel2Protocol;
    }

    public void setWebDavLevel2Protocol(WebDavLevel2Protocol webDavLevel2Protocol) {
        this.webDavLevel2Protocol = webDavLevel2Protocol;
    }

    public boolean isWebdavLevel2Enabled() {
        return this.webdavLevel2Enabled;
    }

    public void setWebdavLevel2Enabled(boolean webdavLevel2Enabled) {
        this.webdavLevel2Enabled = webdavLevel2Enabled;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public AnnotationsCalendarSearchService getAnnotationsCalendarSearchService() {
        return this.annotationsCalendarSearchService;
    }

    public void setAnnotationsCalendarSearchService(AnnotationsCalendarSearchService annotationsCalendarSearchService) {
        this.annotationsCalendarSearchService = annotationsCalendarSearchService;
    }

    public CalendarSearchService getCalendarSearchService() {
        return this.calendarSearchService;
    }

    public void setCalendarSearchService(CalendarSearchService calendarSearchService) {
        this.calendarSearchService = calendarSearchService;
    }

    public PrincipalSearchService getPrincipalSearchService() {
        return this.principalSearchService;
    }

    public void setPrincipalSearchService(PrincipalSearchService principalSearchService) {
        this.principalSearchService = principalSearchService;
    }
}

