/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyEnumElement;
import io.micronaut.ast.groovy.visitor.GroovyMethodElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

@Internal
public class GroovyParameterElement
extends AbstractGroovyElement
implements ParameterElement {
    private final SourceUnit sourceUnit;
    private final Parameter parameter;
    private final GroovyMethodElement methodElement;

    GroovyParameterElement(GroovyMethodElement methodElement, SourceUnit sourceUnit, CompilationUnit compilationUnit, Parameter parameter, AnnotationMetadata annotationMetadata) {
        super(sourceUnit, compilationUnit, (AnnotatedNode)parameter, annotationMetadata);
        this.parameter = parameter;
        this.sourceUnit = sourceUnit;
        this.methodElement = methodElement;
    }

    @Nullable
    public ClassElement getGenericType() {
        ClassElement type = this.getType();
        return this.methodElement.getGenericElement(this.parameter.getType(), type);
    }

    public String getName() {
        return this.parameter.getName();
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPublic() {
        return true;
    }

    public Object getNativeType() {
        return this.parameter;
    }

    @Nonnull
    public ClassElement getType() {
        ClassNode t = this.parameter.getType();
        if (t.isEnum()) {
            return new GroovyEnumElement(this.sourceUnit, this.compilationUnit, t, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)t));
        }
        return new GroovyClassElement(this.sourceUnit, this.compilationUnit, t, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)t));
    }
}

